/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.grounding.bottomUp;

import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.constructs.example.LiftedExample;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundHeadRule;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundRule;
import cz.cvut.fel.ida.logic.constructs.template.components.HeadAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.grounding.GroundTemplate;
import cz.cvut.fel.ida.logic.grounding.Grounder;
import cz.cvut.fel.ida.logic.grounding.constructs.GroundRulesCollection;
import cz.cvut.fel.ida.logic.subsumption.HerbrandModel;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BottomUp
extends Grounder {
    private static final Logger LOG = Logger.getLogger(BottomUp.class.getName());
    long herbrandCumSize = 0L;
    int totalRules = 0;
    long totalGroundRules = 0L;

    public BottomUp(Settings settings) {
        super(settings);
    }

    @Override
    @NotNull
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template) {
        Clause clause;
        this.timing.tic();
        if (template.herbrandModel == null) {
            template.preprocessInference(this.settings.preprocessTemplateInference);
        }
        HerbrandModel herbrandModel = template.herbrandModel;
        List<HornClause> exampleRules = example.getRules();
        herbrandModel.addRules(exampleRules);
        herbrandModel.addFacts(template.getAllAtoms(this.settings.preprocessTemplateInference));
        herbrandModel.addFacts(this.getAllFacts(example));
        example.clause = clause = herbrandModel.setupClause();
        example.clauseE = herbrandModel.getClauseE();
        Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>> rulesAndFacts = this.rulesAndFacts(example, template);
        Map ruleMap = (Map)rulesAndFacts.r;
        Map atomMap = (Map)rulesAndFacts.s;
        LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>> groundRules = new LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>>();
        LOG.fine("Infering Herbrand model...");
        Collection<Literal> literals = herbrandModel.inferAtoms();
        Map<Literal, Literal> allLiterals = literals.stream().collect(Collectors.toMap(l -> l, l -> l));
        LOG.fine("...HerbrandModel inferred with " + allLiterals.size() + " facts");
        this.herbrandCumSize += (long)allLiterals.size();
        LOG.fine("Grounding of " + ruleMap.size() + " rules...");
        this.totalRules += ruleMap.size();
        for (Map.Entry<HornClause, List<WeightedRule>> entry : ruleMap.entrySet()) {
            Map<Literal, ValuedFact> embeddings = this.checkForEmbeddings(entry, herbrandModel);
            if (embeddings != null) {
                atomMap.putAll(embeddings);
                template.facts.addAll(embeddings.values());
                continue;
            }
            Pair<Term[], List<Term[]>> groundingSubstitutions = herbrandModel.groundingSubstitutions(entry.getKey());
            for (WeightedRule weightedRule : entry.getValue()) {
                List<GroundRule> groundings = this.groundRules(weightedRule, groundingSubstitutions);
                boolean splittable = weightedRule.getAggregationFcn() != null && weightedRule.getAggregationFcn().isSplittable();
                for (GroundRule grounding : groundings) {
                    grounding.internLiterals(allLiterals);
                    if (grounding.groundBody.length == 0) {
                        this.storeRuleAsFact(atomMap, weightedRule, grounding);
                        continue;
                    }
                    this.storeGrounding(groundRules, grounding, grounding.groundHead);
                    if (!splittable) continue;
                    Literal maskedHead = grounding.groundHead.maskTerms(weightedRule.getAggregationFcn().aggregableTerms());
                    this.storeGrounding(groundRules, grounding, maskedHead);
                }
            }
        }
        LOG.fine(groundRules.size() + " ground rules created.");
        this.totalGroundRules += (long)groundRules.size();
        GroundTemplate groundTemplate = new GroundTemplate(groundRules, atomMap);
        herbrandModel.removeRules(exampleRules);
        herbrandModel.removeAllAtoms();
        this.timing.toc();
        return groundTemplate;
    }

    @Override
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template, GroundTemplate memory) {
        if (memory == null) {
            memory = new GroundTemplate();
        }
        template.herbrandModel.addFacts(memory.groundFacts.keySet());
        template.herbrandModel.addFacts(memory.derivedGroundFacts);
        GroundTemplate bigger = this.groundRulesAndFacts(example, template);
        GroundTemplate diff = bigger.diffAgainst(memory);
        memory.groundRules = bigger.groundRules;
        memory.groundFacts = bigger.groundFacts;
        memory.derivedGroundFacts = bigger.derivedGroundFacts;
        return diff;
    }

    public List<GroundRule> groundRules(HerbrandModel herbrandModel, WeightedRule liftedRule) {
        return this.groundRules(herbrandModel, liftedRule, liftedRule.toHornClause());
    }

    private Map<Literal, ValuedFact> checkForEmbeddings(Map.Entry<HornClause, List<WeightedRule>> clauseListEntry, HerbrandModel herbrandModel) {
        WeightedRule weightedRule = clauseListEntry.getValue().get(0);
        HeadAtom head = weightedRule.getHead();
        HashMap<Literal, ValuedFact> embeddings = null;
        if (head.getPredicate().special && head.getPredicate().name.startsWith("embed")) {
            if (clauseListEntry.getValue().size() > 1) {
                LOG.severe("There is more than one definition of the same embedding logic in the template...");
            }
            Clause query = new Clause(head.literal);
            Pair<Term[], List<Term[]>> substitutions = herbrandModel.groundingSubstitutions(query);
            embeddings = new HashMap<Literal, ValuedFact>();
            for (int i = 0; i < ((List)substitutions.s).size(); ++i) {
                Term[] terms = (Term[])((List)substitutions.s).get(i);
                Literal groundHead = head.literal.subsCopy(terms);
                Weight weight = this.weightFactory.construct("embed_" + weightedRule.getWeight().name + "-" + i, weightedRule.getWeight().value.getForm(), false, false);
                ValuedFact embedding = new ValuedFact(head.offsettedPredicate, groundHead.termList(), false, weight);
                embeddings.put(groundHead, embedding);
            }
        }
        return embeddings;
    }

    private void storeRuleAsFact(Map<Literal, ValuedFact> atomMap, WeightedRule weightedRule, GroundRule grounding) {
        Weight weight = null;
        if (weightedRule.getWeight() != Weight.unitWeight) {
            weight = weightedRule.getWeight();
        } else if (weightedRule.getHead().getOffset() != null) {
            weight = weightedRule.getHead().getOffset();
        }
        ValuedFact valuedFact = new ValuedFact(weightedRule.getHead().offsettedPredicate, grounding.groundHead.termList(), false, weight);
        valuedFact.originalString = grounding.groundHead.toString();
        atomMap.put(grounding.groundHead, valuedFact);
    }

    public List<GroundRule> groundRules(HerbrandModel herbrandModel, WeightedRule liftedRule, HornClause hc) {
        Pair<Term[], List<Term[]>> substitutions = herbrandModel.groundingSubstitutions(new Clause(hc.getLiterals()));
        return this.groundRules(liftedRule, substitutions);
    }

    public List<GroundRule> groundRules(WeightedRule liftedRule, Pair<Term[], List<Term[]>> substitutions) {
        ArrayList<GroundRule> groundRules = new ArrayList<GroundRule>();
        for (int i = 0; i < ((List)substitutions.s).size(); ++i) {
            GroundRule groundRule = liftedRule.groundRule((Term[])((List)substitutions.s).get(i));
            groundRules.add(groundRule);
        }
        return groundRules;
    }

    private void storeGrounding(LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>> groundRules, GroundRule grounding, Literal groundHead) {
        GroundHeadRule groundHeadRule = grounding.weightedRule.groundHeadRule(groundHead);
        Map groundHeadRules2groundings = groundRules.computeIfAbsent(groundHead, k -> new LinkedHashMap());
        Collection ruleGroundings = groundHeadRules2groundings.computeIfAbsent(groundHeadRule, k -> GroundRulesCollection.getGroundingCollection(grounding.weightedRule));
        ruleGroundings.add(grounding);
    }
}

