/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.grounding.constructs;

import cz.cvut.fel.ida.logic.constructs.template.components.GroundRule;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.setup.Settings;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public abstract class GroundRulesCollection {
    public static GroundRulesCollection get(Settings settings) {
        if (settings.uniqueGroundingsOnly) {
            return new GroundRulesCollectionUnique();
        }
        return new GroundRulesCollectionDuplicit();
    }

    public static Collection<GroundRule> getGroundingCollection(WeightedRule weightedRule) {
        if (weightedRule.allowDuplicitGroundings) {
            return new LinkedList<GroundRule>();
        }
        return new LinkedHashSet<GroundRule>();
    }

    public abstract Collection<GroundRule> getGroundingCollection();

    private static class GroundRulesCollectionUnique
    extends GroundRulesCollection {
        private GroundRulesCollectionUnique() {
        }

        @Override
        public Collection<GroundRule> getGroundingCollection() {
            return new LinkedHashSet<GroundRule>();
        }
    }

    private static class GroundRulesCollectionDuplicit
    extends GroundRulesCollection {
        private GroundRulesCollectionDuplicit() {
        }

        @Override
        public Collection<GroundRule> getGroundingCollection() {
            return new LinkedList<GroundRule>();
        }
    }
}

