/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.grounding.planning;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.logic.constructs.building.factories.ConstantFactory;
import cz.cvut.fel.ida.logic.grounding.planning.State;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import cz.cvut.fel.ida.logic.subsumption.SubsumptionEngineJ2;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Action {
    public static Matching matching = new Matching();
    public static ConstantFactory constantFactory = new ConstantFactory();
    public String name;
    public List<Literal> preconditions;
    public List<Literal> addEffects;
    public List<Literal> deleteEffects;
    public Term[] variables;
    public Literal applicable;
    private SubsumptionEngineJ2.ClauseC preconditionsC;

    public Action(String name, List<String> parameters, List<String> preconditions, List<String> addEffects, List<String> deleteEffects) {
        this.name = name;
        HashMap variables = new HashMap();
        HashMap constants = new HashMap();
        this.preconditions = preconditions.stream().map(lit -> Literal.parseLiteral(lit, variables, constants)).collect(Collectors.toList());
        this.addEffects = addEffects.stream().map(lit -> Literal.parseLiteral(lit, variables, constants)).collect(Collectors.toList());
        this.deleteEffects = deleteEffects.stream().map(lit -> Literal.parseLiteral(lit, variables, constants)).collect(Collectors.toList());
        Set<Variable> vars = this.getVariables(this.preconditions);
        this.variables = vars.toArray(new Variable[0]);
        this.applicable = new Literal(name, this.variables);
    }

    public Action(String name, List<Literal> preconditions, List<Literal> addEffects, List<Literal> deleteEffects) {
        this.name = name;
        this.preconditions = preconditions;
        this.addEffects = addEffects;
        this.deleteEffects = deleteEffects;
        Set<Variable> vars = this.getVariables(preconditions);
        this.variables = vars.toArray(new Variable[0]);
        this.applicable = new Literal(name, this.variables);
    }

    @NotNull
    private Set<Variable> getVariables(List<Literal> preconditions) {
        HashSet<Variable> vars = new HashSet<Variable>();
        for (Literal precondition : preconditions) {
            for (Term term : precondition.termList()) {
                if (!(term instanceof Variable)) continue;
                vars.add((Variable)term);
            }
        }
        return vars;
    }

    public SubsumptionEngineJ2.ClauseC getClauseC(Matching matching) {
        if (this.preconditionsC != null) {
            return this.preconditionsC;
        }
        Clause clause = new Clause(this.preconditions);
        this.preconditionsC = matching.getEngine().createClauseC(clause);
        return this.preconditionsC;
    }

    public Substitutions substitutions(State state) {
        SubsumptionEngineJ2.ClauseE clauseE = state.getClauseE(matching);
        SubsumptionEngineJ2.ClauseC clauseC = this.getClauseC(matching);
        return new Substitutions(matching.allSubstitutions(clauseC, clauseE, Integer.MAX_VALUE));
    }

    public Set<GroundAction> groundings(Substitutions substitutions) {
        HashSet<GroundAction> groundActions = new HashSet<GroundAction>();
        for (Term[] terms : substitutions.constants) {
            GroundAction groundAction = new GroundAction(this, substitutions.variables, terms);
            groundAction.computeEffects(terms);
            groundActions.add(groundAction);
        }
        return groundActions;
    }

    public GroundAction grounding(String constants) {
        String[] split = constants.split(",");
        Term[] consts = new Constant[this.variables.length];
        for (int i = 0; i < split.length; ++i) {
            consts[i] = constantFactory.construct(split[i]);
        }
        GroundAction groundAction = new GroundAction(this, this.variables, consts);
        groundAction.computeEffects(consts);
        return groundAction;
    }

    public static class GroundAction {
        public Action lifted;
        public Literal applicable;
        public List<Literal> preconditions;
        public List<Literal> addEffects;
        public List<Literal> deleteEffects;

        public GroundAction(Action lifted, Term[] variables, Term[] substitution) {
            this.lifted = lifted;
            for (int i = 0; i < variables.length; ++i) {
                variables[i].setIndexWithinSubstitution(i);
            }
            this.applicable = lifted.applicable.subsCopy(substitution);
        }

        public void groundPreconditions(Term[] substitution) {
            this.preconditions = new LinkedList<Literal>();
            for (Literal precondition : this.lifted.preconditions) {
                this.preconditions.add(precondition.subsCopy(substitution));
            }
        }

        public void computeEffects(Term[] substitution) {
            this.addEffects = new LinkedList<Literal>();
            for (Literal addEffect : this.lifted.addEffects) {
                this.addEffects.add(addEffect.subsCopy(substitution));
            }
            this.deleteEffects = new LinkedList<Literal>();
            for (Literal deleteEffect : this.lifted.deleteEffects) {
                this.deleteEffects.add(deleteEffect.subsCopy(substitution));
            }
        }

        public State successor(State state) {
            HashSet<Literal> next = new HashSet<Literal>();
            next.addAll(state.clause.literals());
            next.addAll(this.addEffects);
            this.deleteEffects.forEach(next::remove);
            return new State(new Clause(next));
        }

        public String toString() {
            return this.applicable.toString();
        }
    }

    public static class Substitutions {
        public Term[] variables;
        public List<Term[]> constants;

        public Substitutions(Pair<Term[], List<Term[]>> substitutions) {
            this.variables = (Term[])substitutions.r;
            this.constants = (List)substitutions.s;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.constants.size(); ++i) {
                sb.append(i + ") ");
                Term[] consts = this.constants.get(i);
                for (int j = 0; j < consts.length; ++j) {
                    sb.append(this.variables[j]).append("->").append(consts[j]).append("; ");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

