/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.grounding.topDown;

import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.constructs.building.factories.ConstantFactory;
import cz.cvut.fel.ida.logic.constructs.example.LiftedExample;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundHeadRule;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundRule;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.grounding.GroundTemplate;
import cz.cvut.fel.ida.logic.grounding.Grounder;
import cz.cvut.fel.ida.logic.grounding.constructs.GroundRulesCollection;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class Gringo
extends Grounder {
    private final ConstantFactory constantFactory;
    private String templateStr = "";
    private final Runtime runtime = Runtime.getRuntime();
    private static final Map<String, BiConsumer<Literal, StringBuilder>> specialPredicateMap = new HashMap<String, BiConsumer<Literal, StringBuilder>>();
    private static int anonymousVarCounter = 0;

    private static void specialBinaryPredicateFunction(Literal literal, StringBuilder builder, String divider) {
        builder.append(Gringo.normalizeTerm(literal.arguments()[0].name(), anonymousVarCounter++)).append(divider).append(Gringo.normalizeTerm(literal.arguments()[1].name(), anonymousVarCounter++));
    }

    private static String normalizeTerm(String term, int termCount) {
        if (term.equals("_")) {
            return "AnonymousVariable" + termCount;
        }
        return term;
    }

    public Gringo(Settings settings) {
        super(settings);
        this.constantFactory = new ConstantFactory();
    }

    private void addLiteralToProgram(Literal literal, StringBuilder builder) {
        if (literal.predicate().special) {
            specialPredicateMap.get(literal.predicateName()).accept(literal, builder);
            return;
        }
        builder.append(literal.predicateName()).append("(");
        Term[] terms = literal.arguments();
        for (int i = 0; i < terms.length; ++i) {
            builder.append(Gringo.normalizeTerm(terms[i].name(), anonymousVarCounter++));
            if (i == terms.length - 1) continue;
            builder.append(",");
        }
        builder.append(")");
    }

    private StringBuilder buildProgram(Set<Map.Entry<HornClause, List<WeightedRule>>> ruleEntries, Set<Literal> facts) {
        StringBuilder builder = new StringBuilder();
        for (Literal fact : facts) {
            builder.append("{");
            this.addLiteralToProgram(fact, builder);
            builder.append("}.");
        }
        int index = 0;
        for (Map.Entry<HornClause, List<WeightedRule>> entry : ruleEntries) {
            for (WeightedRule rule : entry.getValue()) {
                anonymousVarCounter = 0;
                builder.append("{");
                this.addLiteralToProgram(rule.getHead().literal, builder);
                builder.append(";__id(");
                builder.append(index);
                builder.append(")}:-");
                ++index;
                List<BodyAtom> bodyAtoms = rule.getBody();
                int size = bodyAtoms.size() - 1;
                for (int i = 0; i < size; ++i) {
                    this.addLiteralToProgram(bodyAtoms.get((int)i).literal, builder);
                    builder.append(",");
                }
                this.addLiteralToProgram(bodyAtoms.get((int)(bodyAtoms.size() - 1)).literal, builder);
                builder.append(".");
            }
        }
        return builder;
    }

    private Literal getGroundedLiteral(Literal literal, List<String> parsedLiteral) {
        Literal copy = literal.emptyCopy();
        Term[] terms = copy.arguments();
        for (int i = 0; i < terms.length; ++i) {
            String term = parsedLiteral.get(i);
            terms[i] = this.constantFactory.construct(term);
        }
        return copy;
    }

    private List<String> parseLiteralFromString(String literal) {
        int len;
        int termIndex = literal.indexOf("(");
        if (termIndex > (len = literal.length()) - 2) {
            return Collections.emptyList();
        }
        int previousIndex = termIndex;
        int commaIndex = -1;
        ArrayList<String> result = new ArrayList<String>();
        while ((commaIndex = literal.indexOf(",", previousIndex + 1)) != -1) {
            result.add(literal.substring(previousIndex + 1, commaIndex));
            previousIndex = commaIndex;
        }
        if (literal.charAt(len - 1) == ')') {
            result.add(literal.substring(previousIndex + 1, len - 1));
        } else {
            result.add(literal.substring(previousIndex + 1, len));
        }
        return result;
    }

    private GroundTemplate getGroundTemplate(Map<HornClause, List<WeightedRule>> ruleMap, Map<Integer, List<List<String>>> groundedHeads, Map<Integer, List<List<List<String>>>> groundedBodies, Map<Literal, ValuedFact> groundFacts) {
        Set<Map.Entry<HornClause, List<WeightedRule>>> ruleEntries = ruleMap.entrySet();
        LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>> groundRules = new LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>>();
        int ruleCounter = 0;
        for (Map.Entry<HornClause, List<WeightedRule>> entry : ruleEntries) {
            for (WeightedRule rule : entry.getValue()) {
                if (!groundedBodies.containsKey(ruleCounter)) {
                    ++ruleCounter;
                    continue;
                }
                List<List<String>> headGroundings = groundedHeads.get(ruleCounter);
                List<List<List<String>>> bodyGroundings = groundedBodies.get(ruleCounter);
                int bodySize = rule.getBody().size();
                ++ruleCounter;
                int groundingSize = headGroundings.size();
                for (int i = 0; i < groundingSize; ++i) {
                    List<String> headGrouding = headGroundings.get(i);
                    List<List<String>> bodyGrounding = bodyGroundings.get(i);
                    Literal groundHead = this.getGroundedLiteral(rule.getHead().literal, headGrouding);
                    ArrayList<Literal> groundBody = new ArrayList<Literal>(bodySize);
                    List<BodyAtom> body = rule.getBody();
                    int offset = bodyGrounding.size() - 1;
                    for (int j = 0; j < bodySize; ++j) {
                        BodyAtom atom = body.get(j);
                        Literal literal = atom.literal;
                        if (literal.predicate().hidden) continue;
                        groundBody.add(this.getGroundedLiteral(literal, bodyGrounding.get(offset--)));
                    }
                    GroundRule grounding = new GroundRule(rule, groundHead, groundBody.toArray(new Literal[groundBody.size()]));
                    Map rules2groundings = groundRules.computeIfAbsent(grounding.groundHead, k -> new LinkedHashMap());
                    GroundHeadRule groundHeadRule = rule.groundHeadRule(grounding.groundHead);
                    Collection ruleGroundings = rules2groundings.computeIfAbsent(groundHeadRule, k -> GroundRulesCollection.getGroundingCollection(rule));
                    ruleGroundings.add(grounding);
                }
            }
        }
        return new GroundTemplate(groundRules, groundFacts);
    }

    private List<List<String>> parseGroundBody(String body) {
        ArrayList<List<String>> parsedBody = new ArrayList<List<String>>();
        int previousIndex = 0;
        while (true) {
            int parentIndex = body.indexOf("(", previousIndex);
            int commaIndex = body.indexOf(",", previousIndex);
            if (parentIndex == -1 && commaIndex == -1) {
                if (previousIndex < body.length()) {
                    parsedBody.add(this.parseLiteralFromString(body.substring(previousIndex)));
                }
                return parsedBody;
            }
            if (commaIndex < parentIndex && commaIndex != -1 || parentIndex == -1) {
                parsedBody.add(this.parseLiteralFromString(body.substring(previousIndex, commaIndex)));
                previousIndex = commaIndex + 1;
                continue;
            }
            int parentCloseIndex = body.indexOf(")", parentIndex);
            parsedBody.add(this.parseLiteralFromString(body.substring(previousIndex, parentCloseIndex)));
            previousIndex = parentCloseIndex + 2;
        }
    }

    @Override
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template) {
        this.timing.tic();
        LinkedHashSet<ValuedFact> templateFacts = template.facts.isEmpty() ? Collections.emptySet() : new LinkedHashSet<ValuedFact>(template.facts);
        Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>> templateRulesAndFacts = this.mapToLogic(new Pair<Set<WeightedRule>, Set<ValuedFact>>(template.rules, templateFacts));
        Map allFacts = (Map)templateRulesAndFacts.s;
        if (this.templateStr.isEmpty()) {
            this.templateStr = this.buildProgram(((Map)templateRulesAndFacts.r).entrySet(), allFacts.keySet()).toString();
        }
        HashMap<Integer, List<List<List<String>>>> groundedBodies = new HashMap<Integer, List<List<List<String>>>>();
        HashMap<Integer, List<List<String>>> groundedHeads = new HashMap<Integer, List<List<String>>>();
        try {
            LinkedHashSet exampleFacts = new LinkedHashSet(example.flatFacts);
            if (example.conjunctions != null && !example.conjunctions.isEmpty()) {
                exampleFacts.addAll(example.conjunctions.stream().flatMap(conj -> conj.facts.stream()).collect(Collectors.toList()));
            }
            Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>> exampleRulesAndFacts = this.mapToLogic(new Pair<Set<WeightedRule>, Set<ValuedFact>>(example.rules, exampleFacts));
            allFacts.putAll((Map)exampleRulesAndFacts.s);
            Path temp = Files.createTempFile("", ".lp", new FileAttribute[0]);
            try (FileWriter fw = new FileWriter(temp.toFile());
                 BufferedWriter bw = new BufferedWriter(fw);){
                bw.write(this.templateStr);
                bw.append(this.buildProgram(((Map)exampleRulesAndFacts.r).entrySet(), ((Map)exampleRulesAndFacts.s).keySet()));
            }
            Process process = this.runtime.exec("gringo " + String.valueOf(temp) + " --text");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int index = line.indexOf(":-");
                    if (index == -1) continue;
                    int headDelimiter = line.indexOf(";");
                    int ruleId = Integer.parseInt(line.substring(headDelimiter + 6, index - 2));
                    String head = line.substring(1, headDelimiter);
                    String bodyLine = line.substring(index + 2, line.length() - 1);
                    groundedBodies.computeIfAbsent(ruleId, k -> new ArrayList()).add(this.parseGroundBody(bodyLine));
                    groundedHeads.computeIfAbsent(ruleId, k -> new ArrayList()).add(this.parseLiteralFromString(head));
                }
            }
            Files.delete(temp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GroundTemplate groundTemplate = this.getGroundTemplate((Map)templateRulesAndFacts.r, groundedHeads, groundedBodies, allFacts);
        this.timing.toc();
        return groundTemplate;
    }

    @Override
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template, GroundTemplate memory) {
        return null;
    }

    static {
        specialPredicateMap.put("@next", (l, b) -> Gringo.specialBinaryPredicateFunction(l, b, " + 1 = "));
        specialPredicateMap.put("@gt", (l, b) -> Gringo.specialBinaryPredicateFunction(l, b, " > "));
        specialPredicateMap.put("@geq", (l, b) -> Gringo.specialBinaryPredicateFunction(l, b, " >= "));
        specialPredicateMap.put("@lt", (l, b) -> Gringo.specialBinaryPredicateFunction(l, b, " < "));
        specialPredicateMap.put("@leq", (l, b) -> Gringo.specialBinaryPredicateFunction(l, b, " <= "));
        specialPredicateMap.put("@eq", (l, b) -> Gringo.specialBinaryPredicateFunction(l, b, " == "));
        specialPredicateMap.put("@neq", (l, b) -> Gringo.specialBinaryPredicateFunction(l, b, " != "));
        specialPredicateMap.put("@alldiff", (l, b) -> {
            Term[] terms = l.arguments();
            if (terms.length <= 1) {
                return;
            }
            for (int i = 0; i < terms.length - 1; ++i) {
                for (int j = i + 1; j < terms.length; ++j) {
                    b.append(Gringo.normalizeTerm(terms[i].name(), anonymousVarCounter++)).append(" != ").append(Gringo.normalizeTerm(terms[j].name(), anonymousVarCounter++));
                    if (i == terms.length - 2 && j == terms.length - 1) continue;
                    b.append(",");
                }
            }
        });
    }
}

