/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.parsing.examples;

import cz.cvut.fel.ida.logic.constructs.Conjunction;
import cz.cvut.fel.ida.logic.constructs.example.LiftedExample;
import cz.cvut.fel.ida.logic.parsing.antlr.NeuralogicParser;
import cz.cvut.fel.ida.logic.parsing.examples.ExamplesParseTreeExtractor;
import cz.cvut.fel.ida.logic.parsing.grammarParsing.PlainGrammarVisitor;
import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.generic.Utilities;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PlainExamplesParseTreeExtractor
extends ExamplesParseTreeExtractor<PlainGrammarVisitor> {
    private static final Logger LOG = Logger.getLogger(PlainExamplesParseTreeExtractor.class.getName());

    public PlainExamplesParseTreeExtractor(PlainGrammarVisitor v) {
        super(v);
    }

    @Override
    public Stream<LiftedExample> getUnlabeledExamples(@NotNull NeuralogicParser.ExamplesFileContext ctx) {
        LOG.info("Parsing examples...");
        PlainGrammarVisitor.LiftedExampleVisitor liftedExampleVisitor = (PlainGrammarVisitor)this.visitor.new PlainGrammarVisitor.LiftedExampleVisitor();
        if (ctx.liftedExample() != null) {
            Stream<LiftedExample> listStream = ctx.liftedExample().stream().map(rule -> rule.accept(liftedExampleVisitor));
            return listStream;
        }
        LOG.severe("Could not extract any Unlabeled trainExamples");
        return null;
    }

    @Override
    public Stream<Pair<Conjunction, LiftedExample>> getLabeledExamples(@NotNull NeuralogicParser.ExamplesFileContext ctx) {
        if (ctx.label() == null || ctx.label().isEmpty()) {
            return this.getUnlabeledExamples(ctx).map(ex -> new Pair<Object, LiftedExample>(null, (LiftedExample)ex));
        }
        return Utilities.zipStreams(this.getQueries(ctx), this.getUnlabeledExamples(ctx), (q, e) -> this.createSamplePair((Conjunction)q, (LiftedExample)e));
    }

    private Pair<Conjunction, LiftedExample> createSamplePair(Conjunction q, LiftedExample e) {
        LOG.finer("Merging query/label " + q.toString() + " with example " + String.valueOf(e));
        return new Pair<Conjunction, LiftedExample>(q, e);
    }

    @Override
    public Stream<Conjunction> getQueries(@NotNull NeuralogicParser.ExamplesFileContext ctx) {
        PlainGrammarVisitor.LabelVisitor labelVisitor = (PlainGrammarVisitor)this.visitor.new PlainGrammarVisitor.LabelVisitor();
        if (ctx.label() != null && !ctx.label().isEmpty()) {
            return ctx.label().stream().map(line -> line.accept(labelVisitor));
        }
        LOG.severe("Could not extract any trainQueries (weighted facts)");
        return null;
    }
}

