/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.parsing.grammarParsing;

import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.StringValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.constructs.Conjunction;
import cz.cvut.fel.ida.logic.constructs.WeightedPredicate;
import cz.cvut.fel.ida.logic.constructs.building.LogicSourceBuilder;
import cz.cvut.fel.ida.logic.constructs.building.factories.VariableFactory;
import cz.cvut.fel.ida.logic.constructs.example.LiftedExample;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.HeadAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.constructs.template.metadata.RuleMetadata;
import cz.cvut.fel.ida.logic.parsing.antlr.NeuralogicBaseVisitor;
import cz.cvut.fel.ida.logic.parsing.antlr.NeuralogicParser;
import cz.cvut.fel.ida.logic.parsing.grammarParsing.GrammarVisitor;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PlainGrammarVisitor
extends GrammarVisitor {
    private static final Logger LOG = Logger.getLogger(PlainGrammarVisitor.class.getName());

    public PlainGrammarVisitor(LogicSourceBuilder builder) {
        super(builder);
    }

    public class TemplateMetadataVisitor
    extends NeuralogicBaseVisitor<Map<String, Object>> {
        @Override
        public Map<String, Object> visitTemplateMetadata(@NotNull NeuralogicParser.TemplateMetadataContext ctx) {
            Map<String, Object> metadata = ctx.metadataList().accept(new MetadataListVisitor());
            return metadata;
        }
    }

    private class MetadataListVisitor
    extends NeuralogicBaseVisitor<Map<String, Object>> {
        private MetadataListVisitor() {
        }

        @Override
        public Map<String, Object> visitMetadataList(@NotNull NeuralogicParser.MetadataListContext ctx) {
            LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
            for (NeuralogicParser.MetadataValContext paramVal : ctx.metadataVal()) {
                String parameter = paramVal.ATOMIC_NAME(0).getText();
                String valueText = null;
                if (paramVal.ATOMIC_NAME(1) != null) {
                    valueText = paramVal.ATOMIC_NAME(1).getText();
                }
                Object value = paramVal.DOLLAR() != null ? PlainGrammarVisitor.this.builder.weightFactory.construct(valueText) : (paramVal.value() != null ? (PlainGrammarVisitor)PlainGrammarVisitor.this.new WeightVisitor().parseValue((NeuralogicParser.ValueContext)paramVal.value()).s : new StringValue(valueText));
                metadata.put(parameter, value);
            }
            return metadata;
        }
    }

    public class PredicateOffsetVisitor
    extends NeuralogicBaseVisitor<Pair<WeightedPredicate, Weight>> {
        @Override
        public Pair<WeightedPredicate, Weight> visitPredicateOffset(@NotNull NeuralogicParser.PredicateOffsetContext ctx) {
            Weight offset;
            int arity = -1;
            try {
                arity = Integer.parseInt(ctx.predicate().INT().getText());
            }
            catch (Exception ex) {
                LOG.severe("Cannot parse arity of a predicate from " + ctx.getText());
            }
            WeightedPredicate predicate = PlainGrammarVisitor.this.builder.predicateFactory.construct(ctx.predicate().ATOMIC_NAME().getText(), arity, ctx.predicate().SPECIAL() != null, ctx.predicate().PRIVATE() != null);
            predicate.weight = offset = ctx.weight().accept(new WeightVisitor());
            return new Pair<WeightedPredicate, Weight>(predicate, offset);
        }
    }

    public class WeightMetadataVisitor
    extends NeuralogicBaseVisitor<Pair<Weight, Map<String, Object>>> {
        @Override
        public Pair<Weight, Map<String, Object>> visitWeightMetadata(@NotNull NeuralogicParser.WeightMetadataContext ctx) {
            Weight weight = PlainGrammarVisitor.this.builder.weightFactory.construct(ctx.ATOMIC_NAME().getText());
            Map<String, Object> metadata = ctx.metadataList().accept(new MetadataListVisitor());
            return new Pair<Weight, Map<String, Object>>(weight, metadata);
        }
    }

    public class PredicateMetadataVisitor
    extends NeuralogicBaseVisitor<Pair<WeightedPredicate, Map<String, Object>>> {
        @Override
        public Pair<WeightedPredicate, Map<String, Object>> visitPredicateMetadata(@NotNull NeuralogicParser.PredicateMetadataContext ctx) {
            int arity = -1;
            try {
                arity = Integer.parseInt(ctx.predicate().INT().getText());
            }
            catch (Exception ex) {
                LOG.severe("Cannot parse arity of a predicate from " + ctx.getText());
            }
            WeightedPredicate predicate = PlainGrammarVisitor.this.builder.predicateFactory.construct(ctx.predicate().ATOMIC_NAME().getText(), arity, ctx.predicate().SPECIAL() != null, ctx.predicate().PRIVATE() != null);
            Map<String, Object> metadata = ctx.metadataList().accept(new MetadataListVisitor());
            return new Pair<WeightedPredicate, Map<String, Object>>(predicate, metadata);
        }
    }

    private class TermVisitor
    extends NeuralogicBaseVisitor<Term> {
        public VariableFactory variableFactory;

        private TermVisitor() {
        }

        @Override
        public Term visitTerm(@NotNull NeuralogicParser.TermContext ctx) {
            Term term;
            if (ctx.constant() != null) {
                term = PlainGrammarVisitor.this.builder.constantFactory.construct(ctx.getText());
            } else if (ctx.variable() != null) {
                term = this.variableFactory.construct(ctx.getText());
            } else {
                LOG.severe("Term is neither Constant nor Variable");
                term = null;
            }
            return term;
        }
    }

    private class WeightVisitor
    extends NeuralogicBaseVisitor<Weight> {
        private WeightVisitor() {
        }

        @Override
        public Weight visitWeight(@NotNull NeuralogicParser.WeightContext ctx) {
            Weight weight;
            Pair<Boolean, Value> value = null;
            boolean fixed = false;
            if (ctx.fixedValue() != null) {
                fixed = true;
                value = this.parseValue(ctx.fixedValue().value());
            } else if (ctx.value() != null) {
                fixed = false;
                value = this.parseValue(ctx.value());
            } else {
                LOG.severe("Weight is neither fixed nor learnable");
            }
            if (ctx.ATOMIC_NAME() != null) {
                String name = ctx.ATOMIC_NAME().getText();
                weight = PlainGrammarVisitor.this.builder.weightFactory.construct(name, (Value)value.s, fixed, (Boolean)value.r);
            } else {
                weight = PlainGrammarVisitor.this.builder.weightFactory.construct((Value)value.s, fixed, (Boolean)value.r);
            }
            return weight;
        }

        public Pair<Boolean, Value> parseValue(NeuralogicParser.ValueContext ctx) {
            Value value = null;
            boolean isInitialized = true;
            if (ctx.number() != null) {
                value = new ScalarValue(Float.parseFloat(ctx.number().getText()));
            } else if (ctx.vector() != null) {
                List<Double> vector = ctx.vector().number().stream().map(num -> Double.parseDouble(num.getText())).collect(Collectors.toList());
                value = new VectorValue(vector);
            } else if (ctx.sparseVector() != null) {
                int length = Integer.parseInt(ctx.sparseVector().INT().getText());
                double[] sparseVector = new double[length];
                for (NeuralogicParser.ElementContext context : ctx.sparseVector().element()) {
                    double v;
                    int i = Integer.parseInt(context.INT().getText());
                    sparseVector[i] = v = Double.parseDouble(context.number().getText());
                }
                value = new VectorValue(sparseVector);
            } else if (ctx.matrix() != null) {
                ArrayList<List<Double>> vectors = new ArrayList<List<Double>>();
                for (NeuralogicParser.VectorContext vectorContext : ctx.matrix().vector()) {
                    List vector = ctx.vector().number().stream().map(num -> Double.parseDouble(num.getText())).collect(Collectors.toList());
                    vectors.add(vector);
                }
                value = new MatrixValue(vectors);
            } else if (ctx.sparseMatrix() != null) {
                int dim1 = Integer.parseInt(ctx.sparseMatrix().INT().get(0).getText());
                int dim2 = Integer.parseInt(ctx.sparseMatrix().INT().get(1).getText());
                double[] sparseMatrix = new double[dim1 * dim2];
                for (NeuralogicParser.Element2dContext context : ctx.sparseMatrix().element2d()) {
                    double v;
                    int i = Integer.parseInt(context.INT().get(0).getText());
                    int j = Integer.parseInt(context.INT().get(1).getText());
                    sparseMatrix[i * dim2 + j] = v = Double.parseDouble(context.number().getText());
                }
                value = new MatrixValue(sparseMatrix, dim1, dim2);
            } else if (ctx.dimensions() != null) {
                isInitialized = false;
                List dims = ctx.dimensions().number().stream().map(num -> Integer.parseInt(num.getText())).collect(Collectors.toList());
                if (dims.size() == 1) {
                    value = (Integer)dims.get(0) == 1 ? new ScalarValue() : new VectorValue((Integer)dims.get(0));
                } else if (dims.size() == 2) {
                    if ((Integer)dims.get(0) == 1 && (Integer)dims.get(1) == 1) {
                        value = new ScalarValue();
                    } else if ((Integer)dims.get(0) == 1) {
                        value = new VectorValue((Integer)dims.get(1));
                        ((VectorValue)value).rowOrientation = true;
                    } else if ((Integer)dims.get(1) == 1) {
                        value = new VectorValue((Integer)dims.get(0));
                        ((VectorValue)value).rowOrientation = false;
                    } else {
                        value = new MatrixValue((Integer)dims.get(0), (Integer)dims.get(1));
                    }
                }
            } else {
                LOG.severe("Value is neither number nor vector: Could not parse numeric value from " + ctx.getText());
            }
            if (value == null) {
                LOG.severe("Error during constructs.building numeric value from " + ctx.getText());
            }
            return new Pair<Boolean, Value>(isInitialized, value);
        }
    }

    private class PredicateVisitor
    extends NeuralogicBaseVisitor<WeightedPredicate> {
        int arity = -1;

        public PredicateVisitor(int arity) {
            this.arity = arity;
        }

        @Override
        public WeightedPredicate visitPredicate(@NotNull NeuralogicParser.PredicateContext ctx) {
            if (ctx.INT() != null) {
                try {
                    this.arity = Integer.parseInt(ctx.INT().getText());
                }
                catch (Exception ex) {
                    LOG.severe("Cannot parse arity of a predicate from " + ctx.getText());
                }
            }
            WeightedPredicate predicate = PlainGrammarVisitor.this.builder.predicateFactory.construct(ctx.ATOMIC_NAME().getText(), this.arity, ctx.SPECIAL() != null, ctx.PRIVATE() != null);
            return predicate;
        }
    }

    public class FactVisitor
    extends NeuralogicBaseVisitor<ValuedFact> {
        public VariableFactory variableFactory = new VariableFactory();

        @Override
        public ValuedFact visitFact(@NotNull NeuralogicParser.FactContext ctx) {
            return this.visitAtom(ctx.atom());
        }

        @Override
        public ValuedFact visitAtom(@NotNull NeuralogicParser.AtomContext ctx) {
            TermVisitor termVisitor = new TermVisitor();
            termVisitor.variableFactory = this.variableFactory;
            List<Object> terms = ctx.termList() != null ? ctx.termList().term().stream().map(term -> term.accept(termVisitor)).collect(Collectors.toList()) : new ArrayList(0);
            WeightedPredicate predicate = ctx.predicate().accept(new PredicateVisitor(terms.size()));
            Weight weight = null;
            if (ctx.weight() != null) {
                weight = ctx.weight().accept(new WeightVisitor());
                if (PlainGrammarVisitor.this.builder.settings.parentCounting && weight.isLearnable()) {
                    LOG.warning("Detected learnable fact values with a parentCounting mode setup - not supported!");
                }
            }
            ValuedFact fact = new ValuedFact(predicate, terms, ctx.negation() != null, weight);
            fact.originalString = ctx.getText();
            return fact;
        }
    }

    public class FactConjunctionVisitor
    extends NeuralogicBaseVisitor<Conjunction> {
        public VariableFactory variableFactory = new VariableFactory();

        @Override
        public Conjunction visitConjunction(@NotNull NeuralogicParser.ConjunctionContext ctx) {
            FactVisitor factVisitor = new FactVisitor();
            factVisitor.variableFactory = this.variableFactory;
            List<ValuedFact> conjunction = ctx.atom().stream().map(atom -> atom.accept(factVisitor)).collect(Collectors.toList());
            return new Conjunction(conjunction);
        }
    }

    public class LabelVisitor
    extends NeuralogicBaseVisitor<Conjunction> {
        public VariableFactory variableFactory;

        @Override
        public Conjunction visitLabel(NeuralogicParser.LabelContext ctx) {
            FactConjunctionVisitor factConjunctionVisitor = new FactConjunctionVisitor();
            Conjunction label = ctx.conjunction().accept(factConjunctionVisitor);
            return label;
        }
    }

    public class LiftedExampleVisitor
    extends NeuralogicBaseVisitor<LiftedExample> {
        VariableFactory variableFactory = new VariableFactory();

        @Override
        public LiftedExample visitLiftedExample(@NotNull NeuralogicParser.LiftedExampleContext ctx) {
            FactConjunctionVisitor factConjunctionVisitor = new FactConjunctionVisitor();
            factConjunctionVisitor.variableFactory = this.variableFactory;
            RuleLineVisitor ruleLineVisitor = new RuleLineVisitor();
            ruleLineVisitor.variableFactory = this.variableFactory;
            List<Conjunction> conjunctions = ctx.conjunction().stream().map(conj -> conj.accept(factConjunctionVisitor)).collect(Collectors.toList());
            List<WeightedRule> rules = ctx.lrnnRule().stream().map(conj -> conj.accept(ruleLineVisitor)).collect(Collectors.toList());
            LiftedExample liftedExample = new LiftedExample(conjunctions, rules);
            LOG.info("Example extracted: " + String.valueOf(liftedExample));
            return liftedExample;
        }
    }

    public class AtomVisitor
    extends NeuralogicBaseVisitor<BodyAtom> {
        VariableFactory variableFactory;

        @Override
        public BodyAtom visitAtom(@NotNull NeuralogicParser.AtomContext ctx) {
            TermVisitor termVisitor = new TermVisitor();
            termVisitor.variableFactory = this.variableFactory;
            List<Object> terms = ctx.termList() != null ? ctx.termList().term().stream().map(term -> term.accept(termVisitor)).collect(Collectors.toList()) : new ArrayList(0);
            WeightedPredicate predicate = ctx.predicate().accept(new PredicateVisitor(terms.size()));
            Weight weight = ctx.weight() != null ? ctx.weight().accept(new WeightVisitor()) : null;
            boolean hardNegation = false;
            Transformation softNegation = null;
            if (ctx.negation() != null) {
                if (ctx.negation().SOFTNEGATION() != null) {
                    softNegation = Transformation.getFunction(PlainGrammarVisitor.this.builder.settings.softNegation);
                } else if (ctx.negation().NEGATION() != null) {
                    hardNegation = true;
                    PlainGrammarVisitor.this.builder.negationDetected = true;
                }
            }
            BodyAtom bodyAtom = new BodyAtom(predicate, terms, hardNegation, softNegation, weight);
            bodyAtom.originalString = ctx.getText();
            return bodyAtom;
        }
    }

    public class AtomConjunctionVisitor
    extends NeuralogicBaseVisitor<List<BodyAtom>> {
        VariableFactory variableFactory;

        @Override
        public List<BodyAtom> visitConjunction(@NotNull NeuralogicParser.ConjunctionContext ctx) {
            AtomVisitor atomVisitor = new AtomVisitor();
            atomVisitor.variableFactory = this.variableFactory;
            List<BodyAtom> atomList = ctx.atom().stream().map(atom -> atom.accept(atomVisitor)).collect(Collectors.toList());
            return atomList;
        }
    }

    public class RuleLineVisitor
    extends NeuralogicBaseVisitor<WeightedRule> {
        VariableFactory variableFactory;

        @Override
        public WeightedRule visitLrnnRule(@NotNull NeuralogicParser.LrnnRuleContext ctx) {
            this.variableFactory = new VariableFactory();
            WeightedRule rule = new WeightedRule();
            rule.setOriginalString(ctx.getText());
            AtomVisitor headVisitor = new AtomVisitor();
            headVisitor.variableFactory = this.variableFactory;
            BodyAtom headAtom = ctx.atom().accept(headVisitor);
            Weight weight = headAtom.getConjunctWeight();
            if (weight == null) {
                rule.setWeight(Weight.unitWeight);
            } else {
                rule.setWeight(weight);
            }
            rule.setHead(new HeadAtom(headAtom));
            AtomConjunctionVisitor bodyVisitor = new AtomConjunctionVisitor();
            bodyVisitor.variableFactory = this.variableFactory;
            rule.setBody(ctx.conjunction().accept(bodyVisitor));
            Weight offset = null;
            if (ctx.offset() != null) {
                offset = ctx.offset().accept(new WeightVisitor());
            } else if (PlainGrammarVisitor.this.builder.settings.ruleAdaptiveOffset) {
                offset = PlainGrammarVisitor.this.builder.settings.defaultRuleOffsetsLearnable ? PlainGrammarVisitor.this.builder.weightFactory.construct(new ScalarValue(-rule.getBody().size()), false, true) : PlainGrammarVisitor.this.builder.weightFactory.construct(new ScalarValue(-rule.getBody().size()), true, true);
            }
            rule.setOffset(offset);
            rule.setMetadata(ctx.metadataList() != null ? new RuleMetadata(PlainGrammarVisitor.this.builder.settings, ctx.metadataList().accept(new MetadataListVisitor())) : null);
            return rule;
        }
    }
}

