/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.subsumption;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.LogicUtils;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.subsumption.CustomPredicate;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import cz.cvut.fel.ida.logic.subsumption.SolutionConsumer;
import cz.cvut.fel.ida.logic.subsumption.SubsumptionEngineJ2;
import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class HerbrandModel {
    private static final Logger LOG = Logger.getLogger(HerbrandModel.class.getName());
    private MultiMap<Predicate, Literal> herbrand = new MultiMap();
    private Matching matching;
    private SubsumptionEngineJ2.ClauseE clauseE;
    private Clause derivedClause;
    public LinkedHashMap<HornClause, PreparedRule> preparedRules = new LinkedHashMap();
    public static Consumer<MultiMap<Predicate, Literal>> callBack;

    public HerbrandModel(Collection<Literal> facts, Collection<HornClause> rules) {
        this.matching = new Matching();
        this.addFacts(facts);
        this.addRules(rules);
    }

    public Collection<Literal> inferAtoms() {
        boolean changed;
        int round = 0;
        int herbrandSize0 = VectorUtils.sum(this.herbrand.sizes());
        LOG.finer("herbrand size before round " + round + " = " + herbrandSize0);
        do {
            if (this.clauseE == null || round > 0) {
                this.setupClause();
            }
            LinkedList<Map.Entry<HornClause, PreparedRule>> entries = new LinkedList<Map.Entry<HornClause, PreparedRule>>(this.preparedRules.entrySet());
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                HornClause rule = (HornClause)next.getKey();
                PreparedRule preparedRule = (PreparedRule)next.getValue();
                if (!preparedRule.isGroundSatisfiable(this.derivedClause)) continue;
                this.matching.getEngine().addSolutionConsumer(preparedRule.solutionConsumer);
                if (preparedRule.isGroundHead) {
                    if (this.matching.subsumption(preparedRule.clauseC, this.clauseE).booleanValue()) {
                        this.herbrand.put(rule.head().predicate(), rule.head());
                        iterator.remove();
                    }
                } else {
                    cz.cvut.fel.ida.utils.generic.tuples.Pair<Term[], List<Term[]>> listPair = this.matching.allSubstitutions(preparedRule.clauseC, this.clauseE, Integer.MAX_VALUE);
                    int n = ((List)listPair.s).size();
                }
                this.matching.getEngine().removeSolutionConsumer(preparedRule.solutionConsumer);
            }
            LOG.finest(() -> this.preparedRules.size() + " rules grounded.");
            int herbrandSize1 = VectorUtils.sum(this.herbrand.sizes());
            LOG.finer("herbrand size after round " + round++ + " = " + herbrandSize1);
            changed = herbrandSize1 > herbrandSize0;
            herbrandSize0 = herbrandSize1;
            if (callBack == null) continue;
            callBack.accept(this.herbrand);
        } while (changed);
        return Sugar.flatten(this.herbrand.values());
    }

    public Pair<Term[], List<Term[]>> groundingSubstitutions(Clause clause) {
        return this.groundingSubstitutions(this.matching.createClauseC(clause));
    }

    public Pair<Term[], List<Term[]>> groundingSubstitutions(HornClause clause) {
        PreparedRule preparedRule = this.preparedRules.get(clause);
        if (this.derivedClause == null) {
            this.derivedClause = new Clause(Sugar.flatten(this.herbrand.values()));
        }
        if (!preparedRule.isGroundSatisfiable(this.derivedClause)) {
            return new Pair<Term[], List<Term[]>>(new Term[0], new ArrayList(0));
        }
        return this.groundingSubstitutions(preparedRule.groundingClause);
    }

    public Pair<Term[], List<Term[]>> groundingSubstitutions(SubsumptionEngineJ2.ClauseC clauseC) {
        if (this.clauseE == null) {
            this.clauseE = this.matching.createClauseE(this.derivedClause);
        }
        return this.groundingSubstitutions(this.clauseE, clauseC);
    }

    public Pair<Term[], List<Term[]>> groundingSubstitutions(SubsumptionEngineJ2.ClauseE clauseE, SubsumptionEngineJ2.ClauseC clauseC) {
        cz.cvut.fel.ida.utils.generic.tuples.Pair<Term[], List<Term[]>> listPair = this.matching.allSubstitutions(clauseC, clauseE, Integer.MAX_VALUE);
        Term[] variables = (Term[])listPair.r;
        for (int i = 0; i < variables.length; ++i) {
            variables[i].setIndexWithinSubstitution(i);
        }
        return new Pair<Term[], List<Term[]>>(variables, (List)listPair.s);
    }

    public void addFacts(Collection<Literal> facts) {
        for (Literal groundLiteral : facts) {
            this.herbrand.put(groundLiteral.predicate(), groundLiteral);
        }
    }

    public Clause setupClause() {
        this.derivedClause = new Clause(Sugar.flatten(this.herbrand.values()));
        this.clauseE = this.matching.createClauseE(this.derivedClause);
        return this.derivedClause;
    }

    public SubsumptionEngineJ2.ClauseE getClauseE() {
        return this.clauseE;
    }

    public void addRules(Collection<HornClause> rules) {
        for (HornClause rule : rules) {
            Predicate headPredicate = rule.head().predicate();
            if (!this.herbrand.containsKey(headPredicate)) {
                this.herbrand.set(headPredicate, Collections.synchronizedSet(new HashSet()));
            }
            boolean isGroundHead = LogicUtils.isGround(rule.head());
            Clause clause = this.prepareClauseForGrounder(rule, isGroundHead);
            SubsumptionEngineJ2.ClauseC clauseC = this.matching.createClauseC(clause);
            PredicateSolutionConsumer solutionConsumer = new PredicateSolutionConsumer(rule.head(), this.herbrand.get(headPredicate));
            this.preparedRules.put(rule, new PreparedRule(rule, clauseC, isGroundHead, solutionConsumer));
        }
    }

    public void removeRules(Collection<HornClause> rules) {
        for (HornClause rule : rules) {
            this.preparedRules.remove(rule);
        }
    }

    public Clause prepareClauseForGrounder(HornClause hc, boolean groundHead) {
        Predicate headPredicate = hc.head().predicate();
        HashSet<Literal> literalSet = new HashSet<Literal>(hc.body().literals());
        this.matching.getEngine().addCustomPredicate(new TupleNotIn(headPredicate, this.herbrand.get(headPredicate)));
        for (Literal l : hc.body().literals()) {
            if (!l.isNegated()) continue;
            literalSet.add(new Literal(HerbrandModel.tupleNotInPredicateName(l.predicate()), false, l.arguments()));
            this.matching.getEngine().addCustomPredicate(new TupleNotIn(l.predicate(), this.herbrand.get(l.predicate())));
        }
        if (!groundHead) {
            literalSet.add(hc.head().negation());
            literalSet.add(new Literal(HerbrandModel.tupleNotInPredicateName(headPredicate), false, hc.head().arguments()));
        }
        Clause clause = new Clause(literalSet);
        return clause;
    }

    private Pair<List<HornClause>, List<Literal>> rulesAndFacts(Collection<? extends Clause> clauses) {
        ArrayList<Literal> groundFacts = new ArrayList<Literal>();
        ArrayList<HornClause> rest = new ArrayList<HornClause>();
        for (Clause clause : clauses) {
            if (clause.countLiterals() == 1 && LogicUtils.isGround(clause)) {
                groundFacts.add(Sugar.chooseOne(clause.literals()));
                continue;
            }
            HornClause hc = new HornClause(clause);
            if (hc.body() == null) continue;
            rest.add(hc);
        }
        return new Pair<List<HornClause>, List<Literal>>(rest, groundFacts);
    }

    public static String tupleNotInPredicateName(Predicate predicate) {
        return "@tuplenotin-" + predicate.name + "/" + predicate.arity;
    }

    public void removeAllAtoms() {
        for (Map.Entry<Predicate, Set<Literal>> predicateSetEntry : this.herbrand.entrySet()) {
            predicateSetEntry.getValue().clear();
        }
    }

    private static class TupleNotIn
    implements CustomPredicate {
        private static final Literal lit = new Literal();
        private Set<Literal> literals;
        private String name;
        private String predicate;

        TupleNotIn(Predicate predicate, Set<Literal> literals) {
            this.predicate = predicate.name;
            this.name = HerbrandModel.tupleNotInPredicateName(predicate);
            this.literals = literals;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isSatisfiable(Term ... arguments) {
            TupleNotIn.lit.predicate().name = this.predicate;
            TupleNotIn.lit.predicate().arity = arguments.length;
            lit.setTerms(arguments);
            return !this.literals.contains(lit);
        }
    }

    private static class PredicateSolutionConsumer
    implements SolutionConsumer {
        Literal ruleHead;
        private Set<Literal> headGroundings;

        private PredicateSolutionConsumer(Literal head, Set<Literal> groundHeads) {
            this.ruleHead = head;
            this.headGroundings = groundHeads;
        }

        @Override
        public void solution(Term[] template, Term[] solution) {
            for (int i = 0; i < template.length; ++i) {
                template[i].setIndexWithinSubstitution(i);
            }
            this.headGroundings.add(this.ruleHead.subsCopy(solution));
        }

        public void clear() {
            this.headGroundings.clear();
        }
    }

    public class PreparedRule {
        final HornClause hornClause;
        List<Literal> groundLiterals;
        final SubsumptionEngineJ2.ClauseC groundingClause;
        final SubsumptionEngineJ2.ClauseC clauseC;
        final boolean isGroundHead;
        final PredicateSolutionConsumer solutionConsumer;

        public PreparedRule(HornClause hornClause, SubsumptionEngineJ2.ClauseC clauseC, boolean isGroundHead, PredicateSolutionConsumer solutionConsumer) {
            this.hornClause = hornClause;
            this.groundingClause = HerbrandModel.this.matching.createClauseC(new Clause(hornClause.getLiterals()));
            this.clauseC = clauseC;
            this.isGroundHead = isGroundHead;
            this.solutionConsumer = solutionConsumer;
            this.loadGroundLiterals();
        }

        private void loadGroundLiterals() {
            this.groundLiterals = new ArrayList<Literal>();
            for (Literal l : this.hornClause.body().literals()) {
                if (l.containsVariable()) continue;
                this.groundLiterals.add(l);
            }
        }

        public boolean isGroundSatisfiable(Clause derivedClause) {
            for (Literal l : this.groundLiterals) {
                if (!(l.isNegated() ? derivedClause.predicates().contains(l.predicateName()) : !l.predicate().special && !derivedClause.predicates().contains(l.predicateName()))) continue;
                return false;
            }
            return true;
        }
    }
}

