/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.subsumption;

import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.utils.math.StringUtils;
import cz.cvut.fel.ida.utils.math.Sugar;
import java.util.Set;

public class SpecialBinaryPredicates {
    public static final String NEQ = "@neq";
    public static final String LEQ = "@leq";
    public static final String GEQ = "@geq";
    public static final String LT = "@lt";
    public static final String GT = "@gt";
    public static final String EQ = "@eq";
    public static final String NEXT = "@next";
    public static final Set<String> SPECIAL_PREDICATES = Sugar.set("@neq", "@leq", "@geq", "@lt", "@gt", "@eq", "@next");

    public static boolean isTrueGround(Literal l) {
        String predicate = l.predicateName();
        boolean ret = false;
        String comparable1 = null;
        String comparable2 = null;
        String str1 = l.get(0).name();
        String str2 = l.get(1).name();
        if (StringUtils.isNumeric(str1) && StringUtils.isNumeric(str2)) {
            Number n1 = StringUtils.parseNumber(str1);
            Number n2 = StringUtils.parseNumber(str2);
            if (predicate.equals(NEQ)) {
                ret = n1.doubleValue() != n2.doubleValue();
            } else if (predicate.equals(EQ)) {
                ret = n1.doubleValue() == n2.doubleValue();
            } else if (predicate.equals(GT)) {
                ret = n1.doubleValue() > n2.doubleValue();
            } else if (predicate.equals(GEQ)) {
                ret = n1.doubleValue() >= n2.doubleValue();
            } else if (predicate.equals(LT)) {
                ret = n1.doubleValue() < n2.doubleValue();
            } else if (predicate.equals(LEQ)) {
                ret = n1.doubleValue() <= n2.doubleValue();
            } else if (predicate.equals(NEXT)) {
                ret = n1.doubleValue() + 1.0 == n2.doubleValue();
            }
        } else {
            comparable1 = str1;
            comparable2 = str2;
            if (predicate.equals(NEQ)) {
                ret = !l.get(0).equals(l.get(1));
            } else if (predicate.equals(EQ)) {
                ret = l.get(0).equals(l.get(1));
            } else if (predicate.equals(GT)) {
                ret = comparable1.compareTo(comparable2) > 0;
            } else if (predicate.equals(GEQ)) {
                ret = comparable1.compareTo(comparable2) >= 0;
            } else if (predicate.equals(LT)) {
                ret = comparable1.compareTo(comparable2) < 0;
            } else if (predicate.equals(LEQ)) {
                boolean bl = ret = comparable1.compareTo(comparable2) <= 0;
            }
        }
        if (l.isNegated()) {
            ret = !ret;
        }
        return ret;
    }
}

