/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.iteration.actions;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.learning.results.Result;
import cz.cvut.fel.ida.neural.networks.computation.iteration.BottomUp;
import cz.cvut.fel.ida.neural.networks.computation.iteration.modes.DFSrecursion;
import cz.cvut.fel.ida.neural.networks.computation.iteration.modes.DFSstack;
import cz.cvut.fel.ida.neural.networks.computation.iteration.modes.Topologic;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.Up;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.neurons.Evaluator;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.QueryNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeurons;
import cz.cvut.fel.ida.neural.networks.structure.components.types.TopologicNetwork;
import cz.cvut.fel.ida.setup.Settings;
import java.util.logging.Logger;

public class Evaluation {
    private static final Logger LOG = Logger.getLogger(Evaluation.class.getName());
    Settings settings;
    Evaluator evaluator;
    Result.Factory resultFactory;

    public Evaluation(Settings settings) {
        this(settings, -1);
    }

    public Evaluation(Settings settings, int index) {
        this.settings = settings;
        this.evaluator = Evaluator.getFrom(settings, index);
        this.resultFactory = new Result.Factory(settings);
    }

    private BottomUp<Value> getBottomUpIterationStrategy(Settings settings, NeuralNetwork<State.Structure> network, Neurons outputNeuron, Evaluator evaluator) {
        Up up = new Up(network, evaluator);
        if (network instanceof TopologicNetwork) {
            return new Topologic((TopologicNetwork)network).new Topologic.BUpVisitor(outputNeuron, up);
        }
        if (settings.iterationMode == Settings.IterationMode.DFS_RECURSIVE) {
            return new DFSrecursion().new DFSrecursion.BUpVisitor(network, outputNeuron, up);
        }
        return new DFSstack().new DFSstack.BUpIterator(network, outputNeuron, up);
    }

    public Result evaluate(NeuralSample sample) {
        Value output = this.evaluate((QueryNeuron)sample.query);
        Result result = this.resultFactory.create(sample.getId(), sample.position, sample.target, output);
        return result;
    }

    public Value evaluate(QueryNeuron queryNeuron) {
        NeuralNetwork network = (NeuralNetwork)queryNeuron.evidence;
        AtomNeurons outputNeuron = queryNeuron.neuron;
        BottomUp<Value> propagator = this.getBottomUpIterationStrategy(this.settings, network, outputNeuron, this.evaluator);
        Value output = propagator.bottomUp().clone();
        return output;
    }
}

