/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.iteration.modes;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronIterating;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.TopDown;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.NeuronVisitor;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.StateVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.weights.WeightUpdater;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.WeightedNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.logging.Logger;

public class BFS {
    private static final Logger LOG = Logger.getLogger(BFS.class.getName());
    Queue<Neurons<Neurons, State.Neural>> queue;

    public class TDownVisitor
    extends NeuronVisiting.Weighted
    implements TopDown {
        StateVisiting.Computation stateVisitor;
        WeightUpdater weightUpdater;

        public TDownVisitor(NeuralNetwork<State.Structure> network, Neurons neuron, StateVisiting.Computation topDown, WeightUpdater weightUpdater) {
            super(network, neuron);
            BFS.this.queue = new ArrayDeque<Neurons<Neurons, State.Neural>>(network.getNeuronCount());
            BFS.this.queue.add(this.outputNeuron);
            this.weightUpdater = weightUpdater;
            this.stateVisitor = topDown;
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
            State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
            Value gradient = this.stateVisitor.visit(state);
            Iterator<T> inputs = this.network.getInputs(neuron, state.getFcnState().getInputMask());
            while (inputs.hasNext()) {
                Neurons input = (Neurons)inputs.next();
                State.Neural.Computation computationView = input.getComputationView(this.stateVisitor.stateIndex);
                computationView.storeGradient(gradient);
                if (!computationView.ready4expansion(this.stateVisitor)) continue;
                BFS.this.queue.add(input);
            }
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
            State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
            Value gradient = this.stateVisitor.visit(state);
            Pair<Iterator<T>, Iterator<Weight>> inputs = this.network.getInputs(neuron, state.getFcnState().getInputMask());
            this.weightUpdater.visit(neuron.offset, gradient);
            Iterator inputNeurons = (Iterator)inputs.r;
            Iterator inputWeights = (Iterator)inputs.s;
            while (inputNeurons.hasNext() && inputWeights.hasNext()) {
                Neurons input = (Neurons)inputNeurons.next();
                Weight weight = (Weight)inputWeights.next();
                State.Neural.Computation inputComputationView = input.getComputationView(this.stateVisitor.stateIndex);
                Value transpInputValue = inputComputationView.getValue().transposedView();
                this.weightUpdater.visit(weight, gradient.times(transpInputValue));
                inputComputationView.storeGradient(gradient.transposedView().times(weight.value));
                if (!inputComputationView.ready4expansion(this.stateVisitor)) continue;
                BFS.this.queue.add(input);
            }
        }

        @Override
        public void topdown() {
            while (!BFS.this.queue.isEmpty()) {
                Neurons<Neurons, State.Neural> neuron = BFS.this.queue.poll();
                neuron.visit(this);
            }
        }
    }

    public class TDownIterator
    extends NeuronIterating
    implements TopDown {
        public TDownIterator(NeuralNetwork<State.Structure> network, Neurons neuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(network, neuron, pureNeuronVisitor);
            BFS.this.queue = new ArrayDeque<Neurons<Neurons, State.Neural>>(network.getNeuronCount());
            BFS.this.queue.add(this.outputNeuron);
        }

        @Override
        public BaseNeuron<Neurons, State.Neural> next() {
            while (!BFS.this.queue.isEmpty()) {
                BaseNeuron poll = (BaseNeuron)BFS.this.queue.poll();
                if (!poll.getComputationView(this.neuronVisitor.stateVisitor.stateIndex).ready4expansion(this.neuronVisitor.stateVisitor)) continue;
                Iterator inputs = this.network.getInputs(poll);
                while (inputs.hasNext()) {
                    Neurons next = (Neurons)inputs.next();
                    BFS.this.queue.add(next);
                }
                return poll;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return !BFS.this.queue.isEmpty();
        }

        @Override
        public void topdown() {
            this.iterate();
        }
    }
}

