/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.iteration.modes;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.neural.networks.computation.iteration.BottomUp;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronIterating;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.TopDown;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.NeuronVisitor;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.StateVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.weights.WeightUpdater;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.WeightedNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Logger;

public class DFSstack {
    private static final Logger LOG = Logger.getLogger(DFSstack.class.getName());
    private Deque<Neurons<Neurons, State.Neural>> stack;

    @Deprecated
    public class BUpVisitor
    extends NeuronVisiting.Weighted
    implements BottomUp<Value> {
        BUpIterator bUpStackIterator;
        NeuronVisitor.Weighted neuronVisitor;

        public BUpVisitor(NeuralNetwork<State.Structure> network, BaseNeuron<Neurons, State.Neural> neuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(network, neuron);
            this.bUpStackIterator = new BUpIterator(network, neuron, pureNeuronVisitor);
            this.neuronVisitor = pureNeuronVisitor;
        }

        @Override
        public Value bottomUp() {
            while (this.bUpStackIterator.hasNext()) {
                Object next = this.bUpStackIterator.next();
                ((BaseNeuron)next).visit(this.neuronVisitor);
            }
            return this.outputNeuron.getComputationView(this.neuronVisitor.stateVisitor.stateIndex).getValue();
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
            ((NeuronVisitor)this.neuronVisitor).visit(neuron);
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
            this.neuronVisitor.visit(neuron);
        }
    }

    public class BUpIterator
    extends NeuronIterating
    implements BottomUp<Value> {
        StateVisiting.Computation stateVisitor;
        Deque<Pair<Boolean, Neurons<Neurons, State.Neural>>> postStack;

        public BUpIterator(NeuralNetwork<State.Structure> network, Neurons neuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(network, neuron, pureNeuronVisitor);
            this.stateVisitor = this.neuronVisitor.stateVisitor;
            this.postStack = new ArrayDeque<Pair<Boolean, Neurons<Neurons, State.Neural>>>(network.getNeuronCount());
            this.postStack.push(new Pair<Boolean, Neurons>(false, this.outputNeuron));
        }

        @Override
        public BaseNeuron<Neurons, State.Neural> next() {
            while (!this.postStack.isEmpty()) {
                Pair<Boolean, Neurons<Neurons, State.Neural>> current = this.postStack.poll();
                if (((Boolean)current.r).booleanValue()) {
                    return (BaseNeuron)current.s;
                }
                this.postStack.push(new Pair<Boolean, Neurons>(true, (Neurons)current.s));
                Iterator inputs = this.network.getInputs((BaseNeuron)current.s);
                while (inputs.hasNext()) {
                    Neurons input = (Neurons)inputs.next();
                    if (input.getComputationView(this.stateVisitor.stateIndex).ready4expansion(this.stateVisitor)) continue;
                    this.postStack.push(new Pair<Boolean, Neurons>(false, input));
                }
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return !this.postStack.isEmpty();
        }

        @Override
        public Value bottomUp() {
            this.iterate();
            return this.outputNeuron.getComputationView(this.neuronVisitor.stateVisitor.stateIndex).getValue();
        }
    }

    public class TDownVisitor
    extends NeuronVisiting.Weighted
    implements TopDown {
        StateVisiting.Computation stateVisitor;
        WeightUpdater weightUpdater;

        public TDownVisitor(NeuralNetwork<State.Structure> network, Neurons neuron, StateVisiting.Computation topDown, WeightUpdater weightUpdater) {
            super(network, neuron);
            DFSstack.this.stack = new ArrayDeque<Neurons<Neurons, State.Neural>>();
            DFSstack.this.stack.push(this.outputNeuron);
            this.weightUpdater = weightUpdater;
            this.stateVisitor = topDown;
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
            State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
            Value value = this.stateVisitor.visit(state);
            Iterator<T> inputs = this.network.getInputs(neuron, state.getFcnState().getInputMask());
            while (inputs.hasNext()) {
                Neurons input = (Neurons)inputs.next();
                State.Neural.Computation computationView = input.getComputationView(this.stateVisitor.stateIndex);
                computationView.storeGradient(value);
                if (!computationView.ready4expansion(this.stateVisitor)) continue;
                DFSstack.this.stack.push(input);
            }
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
            State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
            Value gradient = this.stateVisitor.visit(state);
            Pair<Iterator<T>, Iterator<Weight>> inputs = this.network.getInputs(neuron, state.getFcnState().getInputMask());
            this.weightUpdater.visit(neuron.offset, gradient);
            Iterator inputNeurons = (Iterator)inputs.r;
            Iterator inputWeights = (Iterator)inputs.s;
            while (inputNeurons.hasNext() && inputWeights.hasNext()) {
                Neurons input = (Neurons)inputNeurons.next();
                Weight weight = (Weight)inputWeights.next();
                State.Neural.Computation computationView = input.getComputationView(this.stateVisitor.stateIndex);
                this.weightUpdater.visit(weight, gradient.times(computationView.getValue().transposedView()));
                computationView.storeGradient(gradient.transposedView().times(weight.value));
                if (!computationView.ready4expansion(this.stateVisitor)) continue;
                DFSstack.this.stack.push(input);
            }
        }

        @Override
        public void topdown() {
            while (!DFSstack.this.stack.isEmpty()) {
                Neurons<Neurons, State.Neural> neuron = DFSstack.this.stack.pop();
                neuron.visit(this);
            }
        }
    }

    public class TDownIterator
    extends NeuronIterating
    implements TopDown {
        public TDownIterator(NeuralNetwork<State.Structure> network, Neurons neuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(network, neuron, pureNeuronVisitor);
            DFSstack.this.stack = new ArrayDeque<Neurons<Neurons, State.Neural>>();
            DFSstack.this.stack.push(this.outputNeuron);
        }

        @Override
        public BaseNeuron<Neurons, State.Neural> next() {
            while (!DFSstack.this.stack.isEmpty()) {
                BaseNeuron pop = (BaseNeuron)DFSstack.this.stack.pop();
                if (!pop.getComputationView(this.neuronVisitor.stateVisitor.stateIndex).ready4expansion(this.neuronVisitor.stateVisitor)) continue;
                Iterator inputs = this.network.getInputs(pop);
                while (inputs.hasNext()) {
                    Neurons next = (Neurons)inputs.next();
                    DFSstack.this.stack.add(next);
                }
                return pop;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return !DFSstack.this.stack.isEmpty();
        }

        @Override
        public void topdown() {
            this.iterate();
        }
    }
}

