/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.NeuronVisitor;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.StateVisiting;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.WeightedNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class StateInitializer
extends NeuronVisitor.Weighted {
    private static final Logger LOG = Logger.getLogger(StateInitializer.class.getName());

    public StateInitializer(NeuralNetwork<State.Structure> network, StateVisiting.Computation computationVisitor) {
        super(network, computationVisitor, null);
    }

    @Override
    public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
        State.Neural.Computation computationState = neuron.getComputationView(this.stateVisitor.stateIndex);
        Iterator<T> inputs = this.network.getInputs(neuron);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        while (inputs.hasNext()) {
            Neurons input = (Neurons)inputs.next();
            Value inputValue = input.getComputationView(this.stateVisitor.stateIndex).getValue();
            if (inputValue == null) {
                LOG.severe("Input Value missing for input neuron: " + input.getName() + " of output neuron: " + String.valueOf(neuron) + "The input neuron should have been processed before the output neuron - aren't there cycles in the computation graph?");
            }
            inputValues.add(inputValue);
        }
        ActivationFcn.State updatedState = ActivationFcn.State.getState(computationState.getFcnState(), inputValues);
        computationState.setFcnState(updatedState);
        computationState.initEval(inputValues);
    }

    @Override
    public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
        State.Neural.Computation computationState = neuron.getComputationView(this.stateVisitor.stateIndex);
        Pair<Iterator<T>, Iterator<Weight>> inputs = this.network.getInputs(neuron);
        Iterator inputNeurons = (Iterator)inputs.r;
        Iterator inputWeights = (Iterator)inputs.s;
        ArrayList<Value> inputValues = new ArrayList<Value>();
        if (neuron.offset.value != Value.ZERO) {
            inputValues.add(neuron.offset.value);
        }
        while (inputNeurons.hasNext()) {
            Value times;
            Value inputValue;
            Neurons input = (Neurons)inputNeurons.next();
            Weight weight = (Weight)inputWeights.next();
            if (weight == null) {
                LOG.severe("Weight for input missing, deducing unit weight value for: " + input.getName());
                weight = Weight.unitWeight;
            }
            if ((inputValue = input.getComputationView(this.stateVisitor.stateIndex).getValue()) == null) {
                LOG.severe("Input Value missing for input neuron: " + input.getName() + " of output neuron: " + String.valueOf(neuron) + "The input neuron should have been processed before the output neuron - aren't there cycles in the computation graph?");
            }
            if ((times = weight.value.times(inputValue)) == null) {
                LOG.severe("Weight-Value dimension mismatch at input neuron: " + input.getName() + " of output neuron: " + String.valueOf(neuron));
            }
            inputValues.add(times);
        }
        ActivationFcn.State updatedState = ActivationFcn.State.getState(computationState.getFcnState(), inputValues);
        computationState.setFcnState(updatedState);
        computationState.initEval(inputValues);
    }
}

