/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.NeuronVisitor;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.StateVisiting;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.WeightedNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.Iterator;

public class Up
extends NeuronVisitor.Weighted {
    public Up(NeuralNetwork<State.Structure> network, StateVisiting.Computation computationVisitor) {
        super(network, computationVisitor, null);
    }

    @Override
    public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
        State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
        Iterator<T> inputs = this.network.getInputs(neuron);
        while (inputs.hasNext()) {
            Neurons input = (Neurons)inputs.next();
            state.cumulateValue(input.getComputationView(this.stateVisitor.stateIndex).getValue());
        }
        Value value = this.stateVisitor.visit(state);
    }

    @Override
    public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
        State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
        Pair<Iterator<T>, Iterator<Weight>> inputs = this.network.getInputs(neuron);
        Iterator inputNeurons = (Iterator)inputs.r;
        Iterator inputWeights = (Iterator)inputs.s;
        if (neuron.offset.value != Value.ZERO) {
            state.cumulateValue(neuron.offset.value);
        }
        while (inputNeurons.hasNext()) {
            Neurons input = (Neurons)inputNeurons.next();
            Weight weight = (Weight)inputWeights.next();
            state.cumulateValue(weight.value.times(input.getComputationView(this.stateVisitor.stateIndex).getValue()));
        }
        Value value = this.stateVisitor.visit(state);
    }
}

