/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.training.optimizers;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.weights.WeightUpdater;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.neural.networks.computation.training.optimizers.Adam;
import cz.cvut.fel.ida.neural.networks.computation.training.optimizers.SGD;
import cz.cvut.fel.ida.setup.Settings;
import java.util.Collection;

public interface Optimizer {
    public static Optimizer getFrom(Settings settings, Value learningRate) {
        if (settings.getOptimizer() == Settings.OptimizerSet.SGD) {
            return new SGD(learningRate);
        }
        if (settings.getOptimizer() == Settings.OptimizerSet.ADAM) {
            return new Adam(learningRate);
        }
        return new SGD(learningRate);
    }

    default public void performGradientStep(NeuralModel neuralModel, WeightUpdater weightUpdater, int iteration) {
        this.performGradientStep(weightUpdater.updatedWeightsOnly, weightUpdater.weightUpdates, iteration);
    }

    public void performGradientStep(Collection<Weight> var1, Value[] var2, int var3);

    public void restart(Settings var1);
}

