/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.building;

import cz.cvut.fel.ida.logic.constructs.building.factories.WeightFactory;
import cz.cvut.fel.ida.neural.networks.structure.building.NeuronFactory;
import cz.cvut.fel.ida.neural.networks.structure.building.builders.StatesBuilder;
import cz.cvut.fel.ida.neural.networks.structure.building.factories.NeuralNetFactory;
import cz.cvut.fel.ida.setup.Settings;
import java.util.logging.Logger;

public class NeuralBuilder {
    private static final Logger LOG = Logger.getLogger(NeuralBuilder.class.getName());
    Settings settings;
    public StatesBuilder statesBuilder;
    public NeuronFactory neuronFactory;
    public NeuralNetFactory networkFactory;
    public WeightFactory weightFactory;

    public NeuralBuilder(Settings settings) {
        this.settings = settings;
        this.statesBuilder = new StatesBuilder(settings);
        this.weightFactory = new WeightFactory(settings.inferred.maxWeightCount);
        this.neuronFactory = new NeuronFactory(this.weightFactory, settings);
        this.networkFactory = new NeuralNetFactory(settings);
    }

    public void setFactoriesFrom(NeuralBuilder other) {
        this.neuronFactory = other.neuronFactory;
        this.networkFactory = other.networkFactory;
        this.weightFactory = other.weightFactory;
        this.statesBuilder = other.statesBuilder;
    }
}

