/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.building;

import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundHeadRule;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundRule;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AggregationNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.FactNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.NegationNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.RuleNeurons;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.LinkedMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeuronMaps {
    @NotNull
    public LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>> groundRules;
    @NotNull
    public Map<Literal, ValuedFact> groundFacts;
    public Map<Literal, AtomNeurons> atomNeurons = new HashMap<Literal, AtomNeurons>();
    public Map<GroundHeadRule, AggregationNeuron> aggNeurons = new HashMap<GroundHeadRule, AggregationNeuron>();
    public Map<GroundRule, RuleNeurons> ruleNeurons = new LinkedHashMap<GroundRule, RuleNeurons>();
    public Map<Literal, FactNeuron> factNeurons = new HashMap<Literal, FactNeuron>();
    public Set<NegationNeuron> negationNeurons = new HashSet<NegationNeuron>();
    @Nullable
    public Map<Neurons, LinkedMapping> extraInputMapping = new HashMap<Neurons, LinkedMapping>();
    public boolean containsMasking;

    public NeuronMaps(LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>> groundRules, Map<Literal, ValuedFact> groundFacts) {
        this.groundRules = new LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, Collection<GroundRule>>>(groundRules);
        this.groundFacts = new HashMap<Literal, ValuedFact>(groundFacts);
    }

    public void addAllFrom(NeuronMaps neuronMaps) {
        this.atomNeurons.putAll(neuronMaps.atomNeurons);
        this.aggNeurons.putAll(neuronMaps.aggNeurons);
        this.ruleNeurons.putAll(neuronMaps.ruleNeurons);
        this.factNeurons.putAll(neuronMaps.factNeurons);
        this.extraInputMapping.putAll(neuronMaps.extraInputMapping);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Nmaps: unused ground head literals: ").append(this.groundRules.size());
        sb.append(", unused groundFacts: ").append(this.groundFacts.size());
        sb.append(", atomNeurons: ").append(this.atomNeurons.size());
        sb.append(", aggNeurons: ").append(this.aggNeurons.size());
        sb.append(", ruleNeurons: ").append(this.ruleNeurons.size());
        sb.append(", factNeurons: ").append(this.factNeurons.size());
        sb.append(", negationNeurons: ").append(this.negationNeurons.size());
        return sb.toString();
    }

    private NeuronMaps() {
        this.groundRules = new LinkedHashMap();
        this.groundFacts = new HashMap<Literal, ValuedFact>();
    }

    public Object copy() {
        NeuronMaps copy = new NeuronMaps();
        copy.addAllFrom(this);
        return copy;
    }
}

