/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.building.factories;

import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralSets;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeurons;
import cz.cvut.fel.ida.neural.networks.structure.components.types.DetailedNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.types.TopologicNetwork;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.LinkedMapping;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.NeuronMapping;
import cz.cvut.fel.ida.setup.Settings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class NeuralNetFactory {
    private static final Logger LOG = Logger.getLogger(NeuralNetFactory.class.getName());
    Settings settings;

    public NeuralNetFactory(Settings settings) {
        this.settings = settings;
    }

    public <S extends State.Structure> NeuralNetwork<S> extractOptimizedNetwork(DetailedNetwork<S> network) {
        if (!this.settings.parentCounting) {
            return this.extractTopologicNetwork(network);
        }
        return new NeuralNetwork(network.getId(), network.getNeuronCount());
    }

    public <S extends State.Structure> TopologicNetwork<S> extractTopologicNetwork(DetailedNetwork<S> network) {
        TopologicNetwork topologicNetwork = new TopologicNetwork(network.getId(), network.allNeuronsTopologic, true);
        topologicNetwork.hasSharedNeurons = network.hasSharedNeurons;
        topologicNetwork.containsInputMasking = network.containsInputMasking;
        topologicNetwork.neuronStates = network.neuronStates;
        return topologicNetwork;
    }

    public DetailedNetwork createDetailedNetwork(List<AtomNeurons> queryNeurons, NeuralSets createdNeurons, String id, Map<Neurons, LinkedMapping> extraInputMapping) {
        DetailedNetwork detailedNetwork = queryNeurons != null ? new DetailedNetwork(id, createdNeurons, queryNeurons) : new DetailedNetwork(id, createdNeurons.getAllNeurons(), createdNeurons);
        NeuralNetFactory.trimNeuronInputLists(detailedNetwork.allNeuronsTopologic);
        if (!this.settings.possibleNeuronSharing) {
            detailedNetwork.sortIndices();
        }
        if (extraInputMapping != null && !extraInputMapping.isEmpty()) {
            detailedNetwork.extraInputMapping = new HashMap<BaseNeuron, NeuronMapping<Neurons>>();
            HashSet currentNeurons = new HashSet(detailedNetwork.allNeuronsTopologic);
            for (Map.Entry<Neurons, LinkedMapping> entry : extraInputMapping.entrySet()) {
                if (!currentNeurons.contains(entry.getKey())) continue;
                detailedNetwork.extraInputMapping.putIfAbsent((BaseNeuron)entry.getKey(), (NeuronMapping<Neurons>)entry.getValue());
            }
        }
        return detailedNetwork;
    }

    public static void trimNeuronInputLists(List<BaseNeuron<Neurons, State.Neural>> allNeuronsTopologic) {
        for (BaseNeuron<Neurons, State.Neural> neuron : allNeuronsTopologic) {
            neuron.getInputs().trimToSize();
        }
    }
}

