/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.components;

import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AggregationNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.FactNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.NegationNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.RuleNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.RuleNeurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.WeightedAtomNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.WeightedRuleNeuron;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NeuralSets
implements Exportable {
    public List<AtomNeuron> atomNeurons = new ArrayList<AtomNeuron>();
    public List<WeightedAtomNeuron> weightedAtomNeurons = new ArrayList<WeightedAtomNeuron>();
    public List<AggregationNeuron> aggNeurons;
    public List<RuleNeuron> ruleNeurons;
    public List<WeightedRuleNeuron> weightedRuleNeurons;
    public List<FactNeuron> factNeurons;
    public List<NegationNeuron> negationNeurons;
    List<BaseNeuron> roots;
    List<BaseNeuron> leaves;

    public NeuralSets() {
        this.aggNeurons = new ArrayList<AggregationNeuron>();
        this.ruleNeurons = new ArrayList<RuleNeuron>();
        this.weightedRuleNeurons = new ArrayList<WeightedRuleNeuron>();
        this.factNeurons = new ArrayList<FactNeuron>();
        this.negationNeurons = new ArrayList<NegationNeuron>();
    }

    public NeuralSets(Collection<AtomNeurons> atomNeurons, Collection<AggregationNeuron> aggregationNeurons, Collection<RuleNeurons> ruleNeurons, Collection<FactNeuron> factNeurons, Collection<NegationNeuron> negationNeurons) {
        for (AtomNeurons atomNeuron : atomNeurons) {
            if (atomNeuron instanceof WeightedAtomNeuron) {
                this.weightedAtomNeurons.add((WeightedAtomNeuron)atomNeuron);
                continue;
            }
            this.atomNeurons.add((AtomNeuron)atomNeuron);
        }
        this.aggNeurons = new ArrayList<AggregationNeuron>(aggregationNeurons);
        this.ruleNeurons = new ArrayList<RuleNeuron>();
        this.weightedRuleNeurons = new ArrayList<WeightedRuleNeuron>();
        for (RuleNeurons ruleNeuron : ruleNeurons) {
            if (ruleNeuron instanceof WeightedRuleNeuron) {
                this.weightedRuleNeurons.add((WeightedRuleNeuron)ruleNeuron);
                continue;
            }
            this.ruleNeurons.add((RuleNeuron)ruleNeuron);
        }
        this.factNeurons = new ArrayList<FactNeuron>(factNeurons);
        this.negationNeurons = new ArrayList<NegationNeuron>(negationNeurons);
    }

    public List<Neurons> getAllNeurons() {
        ArrayList<Neurons> allNeurons = new ArrayList<Neurons>();
        allNeurons.addAll(this.atomNeurons);
        allNeurons.addAll(this.weightedAtomNeurons);
        allNeurons.addAll(this.ruleNeurons);
        allNeurons.addAll(this.weightedRuleNeurons);
        allNeurons.addAll(this.aggNeurons);
        allNeurons.addAll(this.factNeurons);
        allNeurons.addAll(this.negationNeurons);
        return allNeurons;
    }

    public NeuronCounter getCounts() {
        return new NeuronCounter(this);
    }

    public class NeuronCounter
    implements Exportable {
        int atomNeuronsCreated;
        int weightedAtomNeuronsCreated;
        int aggNeuronsCreated;
        int ruleNeuronsCreated;
        int weightedRuleNeuronsCreated;
        int factNeuronsCreated;

        public NeuronCounter(NeuralSets neuralSets) {
            this.atomNeuronsCreated = neuralSets.atomNeurons.size();
            this.weightedAtomNeuronsCreated = neuralSets.weightedAtomNeurons.size();
            this.aggNeuronsCreated = neuralSets.aggNeurons.size();
            this.ruleNeuronsCreated = neuralSets.ruleNeurons.size();
            this.weightedRuleNeuronsCreated = neuralSets.weightedRuleNeurons.size();
            this.factNeuronsCreated = neuralSets.factNeurons.size();
        }
    }
}

