/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.components.neurons;

import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.NeuronVisitor;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNeuron<T extends Neurons, S extends State.Neural>
implements Neurons<T, S> {
    private static final Logger LOG = Logger.getLogger(BaseNeuron.class.getName());
    @NotNull
    public int index;
    @Nullable
    public String name;
    @NotNull
    private S state;
    public boolean isShared;
    public boolean sharedAfterCreation;
    @NotNull
    protected ArrayList<T> inputs;
    public int layer;

    public BaseNeuron(int index, String id, S state) {
        this.index = index;
        this.name = id;
        this.state = state;
        this.inputs = new ArrayList();
    }

    protected BaseNeuron() {
    }

    @Override
    public void addInput(T input) {
        this.inputs.add(input);
    }

    @Override
    @NotNull
    public final ArrayList<T> getInputs() {
        return this.inputs;
    }

    public void invalidate() {
        this.state.invalidate();
    }

    @Override
    public Combination getCombination() {
        return this.state.getCombination();
    }

    @Override
    public Transformation getTransformation() {
        return this.state.getTransformation();
    }

    public final boolean hasNoInputs() {
        return this.inputs == null || this.inputs.isEmpty();
    }

    @Override
    public int inputCount() {
        return this.inputs.size();
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public void setShared(boolean b) {
        this.isShared = b;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setLayer(int i) {
        this.layer = i;
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    @Override
    public void visit(NeuronVisitor.Weighted visitor) {
        try {
            ((NeuronVisitor)visitor).visit(this);
        }
        catch (ArithmeticException ex) {
            LOG.severe("ArithmeticException at neuron: " + this.toString());
            throw ex;
        }
    }

    @Override
    public void visit(NeuronVisiting.Weighted visitor) {
        try {
            ((NeuronVisiting)visitor).visit(this);
        }
        catch (ArithmeticException ex) {
            LOG.severe("ArithmeticException at neuron: " + this.toString());
            throw ex;
        }
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BaseNeuron obj1 = (BaseNeuron)obj;
        return this.index == obj1.index;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public final State.Neural.Computation getComputationView(int index) {
        return this.state.getComputationView(index);
    }

    @Override
    public final S getRawState() {
        return this.state;
    }

    public void setState(S finalState) {
        this.state = finalState;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " = " + this.name;
    }
}

