/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.components.neurons;

import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.NeuronVisitor;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public abstract class WeightedNeuron<T extends Neurons, S extends State.Neural>
extends BaseNeuron<T, S> {
    private static final Logger LOG = Logger.getLogger(WeightedNeuron.class.getName());
    public Weight offset;
    protected ArrayList<Weight> weights;

    public WeightedNeuron(String id, int index, S state, Weight offset) {
        super(index, id, state);
        this.offset = offset == null ? Weight.zeroWeight : offset;
        this.weights = new ArrayList();
    }

    protected WeightedNeuron() {
    }

    @Override
    public final void addInput(T input) {
        LOG.warning("Adding unnecessarily weighted input. Use plain Neuron Object for unweighted inputs instead!");
        this.inputs.add(input);
        this.weights.add(Weight.unitWeight);
    }

    public final void addInput(T input, Weight weight) {
        this.inputs.add(input);
        this.weights.add(weight);
    }

    public final ArrayList<Weight> getWeights() {
        return this.weights;
    }

    public final Weight getOffset() {
        return this.offset;
    }

    public final Pair<List<T>, List<Weight>> getInputsWeights() {
        return new Pair<List<T>, List<Weight>>(this.inputs, this.weights);
    }

    public final Iterator<Pair<T, Weight>> getWeightedInputs() {
        return new WeightedInputsIterator(this.inputs, this.weights);
    }

    public final List<Pair<T, Weight>> createWeightedInputs() {
        ArrayList<Pair<T, Weight>> pairedInputs = new ArrayList<Pair<T, Weight>>(this.weights.size());
        for (int i = 0; i < this.weights.size(); ++i) {
            pairedInputs.add(new Pair<Neurons, Weight>((Neurons)this.inputs.get(i), this.weights.get(i)));
        }
        return pairedInputs;
    }

    @Override
    public void visit(NeuronVisitor.Weighted visitor) {
        try {
            visitor.visit(this);
        }
        catch (ArithmeticException ex) {
            LOG.severe("ArithmeticException at neuron: " + this.toString());
            throw ex;
        }
    }

    @Override
    public void visit(NeuronVisiting.Weighted visitor) {
        try {
            visitor.visit(this);
        }
        catch (ArithmeticException ex) {
            LOG.severe("ArithmeticException at neuron: " + this.toString());
            throw ex;
        }
    }

    private final class WeightedInputsIterator
    implements Iterator<Pair<T, Weight>> {
        int index = 0;
        int size;
        ArrayList<T> inputs;
        ArrayList<Weight> weights;

        public WeightedInputsIterator(ArrayList<T> inputs, ArrayList<Weight> weights) {
            this.inputs = inputs;
            this.weights = weights;
            this.size = inputs.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size - 1;
        }

        @Override
        public Pair<T, Weight> next() {
            return new Pair<Neurons, Weight>((Neurons)this.inputs.get(this.index), this.weights.get(this.index));
        }
    }
}

