/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.components.neurons.states;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.StateVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.networks.ParentsTransfer;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.States;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.NeuronMapping;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.WeightedNeuronMapping;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.lang.reflect.Array;
import java.util.List;

public interface State<V>
extends Exportable {
    public void invalidate();

    default public V accept(StateVisiting<V> visitor) {
        return visitor.visit(this);
    }

    public static Neural.Computation createBaseState(Settings settings, Combination combination, Transformation transformation) {
        switch (settings.neuralState) {
            case STANDARD: {
                return new States.ComputationStateStandard(combination, transformation);
            }
            case PARENTS: {
                return new States.ParentCounter(combination, transformation);
            }
            case DROPOUT: {
                return new States.DropoutStore(settings, combination, transformation);
            }
            case PAR_DROPOUT: {
                return new States.DropoutStore.ParentsDropoutStore(new States.DropoutStore(settings, combination, transformation), combination, transformation);
            }
        }
        return new States.ComputationStateStandard(combination, transformation);
    }

    public static <T extends Neural.Computation> States.ComputationStateComposite<T> createCompositeState(T baseState, int copies) {
        Neural.Computation[] batch = (Neural.Computation[])Array.newInstance(baseState.getClass(), copies);
        States.ComputationStateComposite stateComposite = new States.ComputationStateComposite(batch);
        for (int i = 0; i < stateComposite.states.length; ++i) {
            stateComposite.states[i] = baseState.clone();
        }
        return stateComposite;
    }

    public static interface Structure<V>
    extends State<V> {
        public static StateVisiting.Computation getStatesInitializer(Settings settings) {
            return new ParentsTransfer(-1);
        }

        public static interface OutputNeuronMap
        extends Structure<NeuronMapping<Neurons>> {
            public NeuronMapping<Neurons> getOutputMapping();
        }

        public static interface WeightedInputsMap
        extends Structure<WeightedNeuronMapping<Neurons>> {
            public WeightedNeuronMapping<Neurons> getWeightedMapping();
        }

        public static interface InputNeuronMap
        extends Structure<NeuronMapping<Neurons>> {
            public NeuronMapping<Neurons> getInputMapping();
        }

        public static interface Parents {
            public int getParentCount();

            public void setParentCount(int var1);

            public Neural<Value> getParentCounter();
        }
    }

    public static interface Neural<V>
    extends State<V> {
        public Computation getComputationView(int var1);

        public Combination getCombination();

        public Transformation getTransformation();

        public static interface Computation
        extends Neural<Value> {
            public Computation clone();

            public Value initEval(List<Value> var1);

            public Value evaluate();

            public ActivationFcn.State getFcnState();

            public void setFcnState(ActivationFcn.State var1);

            public Value getValue();

            public Value getGradient();

            public void setValue(Value var1);

            public void setGradient(Value var1);

            public void cumulateValue(Value var1);

            public void storeGradient(Value var1);

            @Override
            default public Computation getComputationView(int index) {
                return this;
            }

            default public boolean ready4expansion(StateVisiting visitor) {
                return true;
            }

            public static interface Detailed {
                public List<Value> getMessages();

                public void setMessages(List<Value> var1);
            }

            public static interface HasDropout {
                default public void setStartingRate(Settings settings, int layer) {
                    this.setDropoutRate(settings.dropoutRate / (double)layer);
                }

                public double getDropoutRate(StateVisiting var1);

                public void setDropoutRate(double var1);

                public void setDropout(StateVisiting var1);
            }

            public static interface HasParents {
                public int getParents(StateVisiting var1);

                public int getChecked(StateVisiting var1);

                public void setChecked(StateVisiting var1, int var2);

                public void setParents(StateVisiting var1, int var2);
            }
        }
    }
}

