/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.components.neurons.states;

import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.StateVisiting;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.setup.Settings;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class StatesCache<T extends State.Structure> {
    private static final Logger LOG = Logger.getLogger(StatesCache.class.getName());
    T[] neuronStates;
    StateVisiting.Computation initializer;

    public StatesCache(T[] neuronStates, StateVisiting.Computation initializer) {
        this.neuronStates = neuronStates;
        this.initializer = initializer;
    }

    protected abstract int findNeuron(int var1);

    @Deprecated
    public T getState(int index) {
        return this.neuronStates[index];
    }

    public T getState(Neurons neuron) {
        int idx = this.findNeuron(neuron.getIndex());
        if (idx < 0 || idx > this.neuronStates.length) {
            LOG.severe("ERROR - out of bounds access to getState of a neuron: " + String.valueOf(neuron));
            return null;
        }
        return this.neuronStates[idx];
    }

    public void initialize(int stateView) {
        this.initializer.stateIndex = stateView;
        for (T neuronState : this.neuronStates) {
            neuronState.accept(this.initializer);
        }
    }

    public static <T extends State.Structure> StatesCache<T> getCache(Settings settings, T[] states) {
        StateVisiting.Computation initializer = State.Structure.getStatesInitializer(settings);
        if (settings.iterationMode == Settings.IterationMode.TOPOLOGIC) {
            return new DirectCache((State.Structure[])states, initializer);
        }
        if (states.length < settings.lin2bst) {
            return new LinearCache((State.Structure[])states, initializer);
        }
        if (states.length > settings.lin2bst && states.length < settings.bst2hashmap) {
            return new HeapCache((State.Structure[])states, initializer);
        }
        return new HashCache((State.Structure[])states, initializer);
    }

    public static class DirectCache
    extends StatesCache {
        public DirectCache(State.Structure[] neuronStates, StateVisiting.Computation initializer) {
            super(neuronStates, initializer);
        }

        @Override
        protected int findNeuron(int idx) {
            return idx;
        }
    }

    public static class HashCache
    extends StatesCache {
        public HashMap<Integer, Integer> neuronIndices;

        public HashCache(State.Structure[] neuronStates, StateVisiting.Computation initializer) {
            super(neuronStates, initializer);
        }

        @Override
        protected int findNeuron(int idx) {
            return this.neuronIndices.get(idx);
        }
    }

    public static class HeapCache
    extends StatesCache {
        private int[] heapSortedNeuronIndices;

        public HeapCache(State.Structure[] neuronStates, StateVisiting.Computation initializer) {
            super(neuronStates, initializer);
        }

        @Override
        public int findNeuron(int target) {
            int index = 0;
            while (index < this.heapSortedNeuronIndices.length) {
                if (target >= this.heapSortedNeuronIndices[index]) {
                    index <<= 2;
                    continue;
                }
                if (target < this.heapSortedNeuronIndices[index]) {
                    index <<= 3;
                    continue;
                }
                return index;
            }
            return -1;
        }
    }

    public static class LinearCache
    extends StatesCache {
        private int[] neuronIndices;

        public LinearCache(State.Structure[] neuronStates, StateVisiting.Computation initializer) {
            super(neuronStates, initializer);
        }

        @Override
        public int findNeuron(int index) {
            for (int i = 0; i < this.neuronIndices.length; ++i) {
                if (this.neuronIndices[i] != index) continue;
                return i;
            }
            return -1;
        }
    }
}

