/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.components.types;

import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.WeightedNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeurons;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TopologicNetwork<N extends State.Structure>
extends NeuralNetwork<N> {
    private static final Logger LOG = Logger.getLogger(TopologicNetwork.class.getName());
    public List<BaseNeuron<Neurons, State.Neural>> allNeuronsTopologic;

    public TopologicNetwork(String id, List<BaseNeuron<Neurons, State.Neural>> allNeurons) {
        super(id, allNeurons.size());
        this.allNeuronsTopologic = new TopoSorting().topologicSort(allNeurons);
        if (this.allNeuronsTopologic.size() != allNeurons.size()) {
            LOG.warning("Some neurons connected in the network are not in neuronmaps!");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(this.allNeuronsTopologic.toString());
        }
    }

    public TopologicNetwork(String id, int size) {
        super(id, size);
        this.allNeuronsTopologic = new ArrayList<BaseNeuron<Neurons, State.Neural>>(size);
    }

    public TopologicNetwork(String id, List<BaseNeuron<Neurons, State.Neural>> allNeurons, boolean sorted) {
        super(id, allNeurons.size());
        this.allNeuronsTopologic = allNeurons;
    }

    public TopologicNetwork(List<AtomNeurons> queryNeurons, String id) {
        super(id, -1);
        this.allNeuronsTopologic = new TopoSorting().topologicSort(queryNeurons);
        this.neuronCount = this.allNeuronsTopologic.size();
    }

    public void sortIndices() {
        int[] indices = new int[this.allNeuronsTopologic.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.allNeuronsTopologic.get((int)i).index;
        }
        Arrays.sort(indices);
        int prev = -1;
        for (int i = 0; i < this.allNeuronsTopologic.size(); ++i) {
            this.allNeuronsTopologic.get((int)i).index = indices[i];
            if (indices[i] == prev) {
                LOG.severe("Duplicit neuron indices detected!!");
            }
            prev = indices[i];
        }
    }

    public void restartIndices() {
        for (int i = 0; i < this.allNeuronsTopologic.size(); ++i) {
            this.allNeuronsTopologic.get((int)i).index = i;
        }
    }

    @Deprecated
    public N getState(int index) {
        return (N)this.neuronStates.getState(index);
    }

    @Override
    public N getState(Neurons neuron) {
        if (this.neuronStates != null) {
            return (N)this.neuronStates.getState(neuron.getIndex());
        }
        return null;
    }

    @Override
    public String toString() {
        return "net:" + this.id + ", neurons: " + this.allNeuronsTopologic.size();
    }

    public class TopoSorting {
        LinkedList<Neurons> topoList = new LinkedList();
        static final int OPEN = 1;
        static final int CLOSED = -1;
        static final int DEFAULT = 0;

        public List<BaseNeuron<Neurons, State.Neural>> topologicSort(List<? extends Neurons> startNeurons) {
            for (Neurons neurons : startNeurons) {
                if (neurons == null || neurons.getLayer() != 0) continue;
                this.topoSortRecursive(neurons);
            }
            ArrayList<BaseNeuron<Neurons, State.Neural>> reverse = new ArrayList<BaseNeuron<Neurons, State.Neural>>(this.topoList.size());
            Iterator<Neurons> iterator = this.topoList.descendingIterator();
            while (iterator.hasNext()) {
                BaseNeuron next = (BaseNeuron)iterator.next();
                next.setLayer(0);
                reverse.add(next);
            }
            return reverse;
        }

        private void topoSortRecursive(Neurons neuron) {
            neuron.setLayer(1);
            Iterator<Neurons> inputs = TopologicNetwork.this.getInputs(neuron);
            while (inputs.hasNext()) {
                Neurons input = (Neurons)inputs.next();
                if (input.getLayer() != 1) {
                    if (input.getLayer() == -1) continue;
                    this.topoSortRecursive(input);
                    continue;
                }
                this.removeBackEdge(neuron, inputs, input);
                LOG.warning("Cycle detected in ground neural network. A backEdge: " + String.valueOf(neuron) + " --> " + String.valueOf(input) + " has been removed!");
            }
            neuron.setLayer(-1);
            this.topoList.addFirst(neuron);
        }

        private void removeBackEdge(Neurons neuron, Iterator<Neurons> inputs, Neurons input) {
            if (neuron instanceof WeightedNeuron) {
                Pair weightedInputs = TopologicNetwork.this.getInputs((WeightedNeuron)neuron);
                Iterator inputNeurons = (Iterator)weightedInputs.r;
                Iterator inputWeights = (Iterator)weightedInputs.s;
                while (inputNeurons.hasNext()) {
                    inputWeights.next();
                    if (inputNeurons.next() != input) continue;
                    inputWeights.remove();
                    break;
                }
            }
            inputs.remove();
        }
    }
}

