/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings;

import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.LinkedMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class NeuronMapping<T extends Neurons>
implements LinkedMapping<T> {
    private static final Logger LOG = Logger.getLogger(NeuronMapping.class.getName());
    List<T> inputs;
    public NeuronMapping<T> previous;

    public NeuronMapping(List<T> inputs) {
        this.previous = new NeuronMapping<T>();
        this.previous.inputs = new ArrayList<T>(inputs);
        this.inputs = new ArrayList<T>();
    }

    public NeuronMapping(NeuronMapping<T> previous) {
        this.previous = previous;
        this.inputs = new ArrayList<T>();
    }

    public NeuronMapping() {
        this.inputs = new ArrayList<T>();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new InputIterator(this);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public List<T> getLastList() {
        return this.inputs;
    }

    @Override
    public void addLink(T input) {
        this.inputs.add(input);
    }

    @Override
    public void removeLink(T input) {
        this.inputs.remove(input);
    }

    public LinkedMapping<T> getInputs(BaseNeuron neuron) {
        return this;
    }

    public void replace(T toReplace, T replaceWith) {
        InputIterator inputIterator = new InputIterator(this);
        while (inputIterator.hasNext()) {
            NeuronMapping<T> lastMapping = inputIterator.actual;
            Object next = inputIterator.next();
            if (!next.equals(toReplace)) continue;
            if (inputIterator.current == inputIterator.actual.inputs.size() - 1) {
                lastMapping.replaceLocal(0, replaceWith);
                continue;
            }
            inputIterator.actual.replaceLocal(inputIterator.current + 1, replaceWith);
        }
    }

    private void replaceLocal(int i, T replaceWith) {
        if (replaceWith == null) {
            this.inputs.remove(i);
        } else {
            this.inputs.set(i, replaceWith);
        }
    }

    private class InputIterator<T extends Neurons>
    implements Iterator<T> {
        NeuronMapping<T> actual;
        int current;

        public InputIterator(NeuronMapping<T> inputMapping) {
            this.actual = inputMapping;
            this.current = this.actual.inputs.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.actual.previous != null || this.current >= 0;
        }

        @Override
        public T next() {
            if (this.current >= 0) {
                return (T)((Neurons)this.actual.inputs.get(this.current--));
            }
            if (this.actual.previous != null) {
                this.actual = this.actual.previous;
                this.current = this.actual.inputs.size() - 1;
                return (T)((Neurons)this.actual.inputs.get(this.current--));
            }
            return null;
        }
    }
}

