/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.transforming;

import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.QueryNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.neural.networks.structure.components.types.DetailedNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.types.TopologicNetwork;
import cz.cvut.fel.ida.neural.networks.structure.transforming.IsoValueNetworkCompressor;
import cz.cvut.fel.ida.neural.networks.structure.transforming.LinearChainReducer;
import cz.cvut.fel.ida.neural.networks.structure.transforming.ParallelEdgeMerger;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.ArrayList;
import java.util.List;

public interface NetworkReducing
extends Exportable {
    public NeuralNetwork reduce(DetailedNetwork<State.Structure> var1, List<QueryNeuron> var2);

    public NeuralNetwork reduce(DetailedNetwork<State.Structure> var1, QueryNeuron var2);

    public static NetworkReducing getReducer(Settings settings) {
        return new LinearChainReducer(settings);
    }

    public static NetworkReducing getCompressor(Settings settings) {
        return new IsoValueNetworkCompressor(settings);
    }

    public static NetworkReducing getEdgeMerger(Settings settings) {
        return new ParallelEdgeMerger(settings);
    }

    public static void supervisedNetReconstruction(DetailedNetwork<State.Structure> inet, List<Neurons> allQueryNeurons) {
        if (allQueryNeurons == null || allQueryNeurons.isEmpty() || allQueryNeurons.get(0) == null) {
            allQueryNeurons = new ArrayList<Neurons>(inet.allNeuronsTopologic);
        }
        inet.allNeuronsTopologic = new TopologicNetwork.TopoSorting(inet).topologicSort(allQueryNeurons);
    }

    public void finish();
}

