/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neuralogic.cli.utils;

import cz.cvut.fel.ida.logging.Logging;
import cz.cvut.fel.ida.neuralogic.cli.utils.CommandLineHandler;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.building.LearningSchemeBuilder;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.SourceFiles;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.exporting.Exporter;
import cz.cvut.fel.ida.utils.exporting.TextExporter;
import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.generic.Utilities;
import java.io.File;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public class Runner {
    private static final Logger LOG = Logger.getLogger(Runner.class.getName());

    public static void main(String[] args) throws Exception {
        Runner.main(args, new Settings());
    }

    public static Pair<Pipeline, ?> main(String[] args, Settings settings) throws Exception {
        if (settings == null) {
            settings = new Settings();
        }
        Logging logging = Logging.initLogging(settings);
        Sources sources = Runner.getSources(args, settings);
        logging.initialize(Settings.loggingLevel, Settings.supressLogFileOutput, Settings.customLogColors);
        Pipeline<Sources, ?> pipeline = LearningSchemeBuilder.getPipeline(settings, sources);
        LOG.finest("Running the main pipeline on the provided sources...");
        Pair<String, ?> result = pipeline.execute(sources);
        LOG.info("Pipeline: " + (String)result.r + " finished with result: " + result.s.toString());
        logging.finish();
        return new Pair(pipeline, result.s);
    }

    public static Sources getSources(String[] args, Settings settings) throws Exception {
        CommandLineHandler cmdh = new CommandLineHandler();
        CommandLine cmd = null;
        try {
            cmd = cmdh.parseParams(args, settings);
        }
        catch (ParseException ex) {
            Utilities.myExit(LOG, "Unable to parse Commandline arguments!" + String.valueOf(ex));
        }
        Sources sources = Sources.getSources(cmd, settings);
        Runner.startupExport(settings, sources);
        return sources;
    }

    private static void startupExport(Settings settings, Sources sources) {
        Exporter exporter = Exporter.getExporter(settings.exportDir, "", settings.exportType.name());
        if (settings.cleanUpFirst) {
            exporter.deleteDir(new File(settings.exportDir));
        }
        LOG.info("Exporting Settings configuration:");
        TextExporter.exportString(settings.export(), Paths.get(settings.settingsExportFile, new String[0]));
        LOG.info("Exporting Sources configuration:");
        TextExporter.exportString(sources.export(), Paths.get(settings.sourcesExportFile, new String[0]));
    }

    private static String makeCompatibleExportDir(Settings settings, Sources sources) {
        SourceFiles sourceFiles = (SourceFiles)sources;
        StringBuilder sb = new StringBuilder();
        String template = sourceFiles.template.getName().replace(".txt", "");
        String dataset = sourceFiles.trainExamples.getParentFile().getName();
        String params = settings.getChangesFromReference();
        sb.append(dataset).append("/").append(template).append("/").append(params);
        return sb.toString();
    }

    public static String testConnection(String socket) {
        return socket + " succesfully connected";
    }
}

