/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.logic.constructs.building.factories.WeightFactory;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.grounding.Grounder;
import cz.cvut.fel.ida.logic.grounding.GroundingSample;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.debugging.GroundingDebugger;
import cz.cvut.fel.ida.pipelines.pipes.generic.ExportingPipe;
import cz.cvut.fel.ida.pipelines.pipes.generic.StreamParallelizationPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.GlobalSharingGroundingPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.GroundingSampleWrappingPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.SequentiallySharedGroundingPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.StandardGroundingPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.SupervisedGroundTemplatePruningPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.SupervisedTemplateReducingPipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class GroundingBuilder
extends AbstractPipelineBuilder<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> {
    private static final Logger LOG = Logger.getLogger(GroundingBuilder.class.getName());
    protected WeightFactory weightFactory;

    public GroundingBuilder(Settings settings) {
        super(settings);
    }

    public GroundingBuilder(Settings settings, WeightFactory weightFactory) {
        this(settings);
        this.weightFactory = weightFactory;
    }

    @Override
    public Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> buildPipeline() {
        Pipe groundingPipe;
        Pipe nextPipe;
        Grounder grounder = Grounder.getGrounder(this.settings);
        if (this.weightFactory != null) {
            grounder.weightFactory = this.weightFactory;
        }
        this.weightFactory = grounder.weightFactory;
        Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> pipeline = new Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>>("GroundingPipeline", this);
        GroundingSampleWrappingPipe groundingSamples = pipeline.registerStart(new GroundingSampleWrappingPipe(this.settings));
        if (this.settings.parallelGrounding) {
            StreamParallelizationPipe parallelPipe = pipeline.register(new StreamParallelizationPipe());
            groundingSamples.connectAfter(parallelPipe);
            nextPipe = parallelPipe;
        } else {
            nextPipe = groundingSamples;
        }
        if (this.settings.supervisedTemplateGraphPruning) {
            SupervisedTemplateReducingPipe templateReducing = pipeline.register(new SupervisedTemplateReducingPipe());
            nextPipe.connectAfter(templateReducing);
            nextPipe = templateReducing;
        }
        if (this.settings.groundingMode == Settings.GroundingMode.SEQUENTIAL) {
            groundingPipe = pipeline.registerEnd(new SequentiallySharedGroundingPipe(grounder));
            nextPipe.connectAfter(groundingPipe);
            nextPipe = groundingPipe;
        } else if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL) {
            groundingPipe = pipeline.registerEnd(new GlobalSharingGroundingPipe(grounder));
            nextPipe.connectAfter(groundingPipe);
            nextPipe = groundingPipe;
        } else {
            groundingPipe = pipeline.registerEnd(new StandardGroundingPipe(grounder));
            nextPipe.connectAfter(groundingPipe);
            nextPipe = groundingPipe;
        }
        if (pipeline.exporter != null) {
            ExportingPipe exportingPipe = pipeline.registerEnd(new ExportingPipe(grounder, pipeline.exporter, grounder.timing, this.settings));
            nextPipe.connectAfter(exportingPipe);
            nextPipe = exportingPipe;
        }
        if (this.settings.explicitSupervisedGroundTemplatePruning) {
            SupervisedGroundTemplatePruningPipe groundReducingPipe = pipeline.registerEnd(new SupervisedGroundTemplatePruningPipe());
            nextPipe.connectAfter(groundReducingPipe);
            nextPipe = groundReducingPipe;
        }
        if (this.settings.debugGrounding) {
            new GroundingDebugger(this.settings).addDebugStream(pipeline);
        }
        return pipeline;
    }
}

