/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.logic.constructs.building.factories.WeightFactory;
import cz.cvut.fel.ida.logic.grounding.GroundingSample;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.neural.networks.structure.building.NeuralProcessingSample;
import cz.cvut.fel.ida.neural.networks.structure.building.Neuralizer;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.QueryNeuron;
import cz.cvut.fel.ida.pipelines.Block;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.debugging.NeuralDebugger;
import cz.cvut.fel.ida.pipelines.pipes.generic.ExportingPipe;
import cz.cvut.fel.ida.pipelines.pipes.generic.IdentityGenPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.CompressionPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.CycleBreakingPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.EdgeMergerPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.NetworkFinalizationPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.PruningPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.SameQueryAggregationPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.SupervisedNeuralizationPipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Utilities;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class NeuralNetsBuilder
extends AbstractPipelineBuilder<Stream<GroundingSample>, Stream<NeuralSample>> {
    private static final Logger LOG = Logger.getLogger(NeuralNetsBuilder.class.getName());
    private WeightFactory weightFactory;

    public NeuralNetsBuilder(Settings settings) {
        super(settings);
    }

    public NeuralNetsBuilder(Settings settings, WeightFactory weightFactory) {
        super(settings);
        this.weightFactory = weightFactory;
    }

    @Override
    public Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> buildPipeline() {
        final Neuralizer neuralizer = new Neuralizer(this.settings, this.weightFactory);
        Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> pipeline = new Pipeline<Stream<GroundingSample>, Stream<NeuralSample>>("NeuralizationPipeline", this);
        Block nextPipe = null;
        nextPipe = pipeline.registerStart(new SupervisedNeuralizationPipe(this.settings, neuralizer));
        if (pipeline.exporter != null) {
            ExportingPipe exportingPipe = pipeline.register(new ExportingPipe(neuralizer, pipeline.exporter, neuralizer.timing, this.settings));
            nextPipe.connectAfter(exportingPipe);
            nextPipe = exportingPipe;
        }
        if (this.settings.neuralNetsPostProcessing) {
            Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> postprocessingPipeline = pipeline.register(this.buildProcessingPipeline());
            nextPipe.connectAfter(postprocessingPipeline);
            nextPipe = postprocessingPipeline;
        } else {
            LOG.warning("Skipping all neural optimization steps!");
        }
        NetworkFinalizationPipe finalizationPipe = pipeline.register(new NetworkFinalizationPipe(this.settings, neuralizer.neuralNetBuilder));
        nextPipe.connectAfter(finalizationPipe);
        1 cutoffPipe = pipeline.registerEnd(new Pipe<Stream<NeuralProcessingSample>, Stream<NeuralSample>>("ReleaseMemoryPipe", this.settings){

            @Override
            public Stream<NeuralSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
                return neuralProcessingSampleStream.map(s -> {
                    ((QueryNeuron)s.query).evidence = neuralizer2.neuralNetBuilder.neuralBuilder.networkFactory.extractOptimizedNetwork(s.detailedNetwork);
                    if (this.settings.groundingMode != Settings.GroundingMode.GLOBAL) {
                        Utilities.logMemory();
                    }
                    return new NeuralSample(s.target, (QueryNeuron)s.query, s.type);
                });
            }
        });
        finalizationPipe.connectAfter(cutoffPipe);
        if (this.settings.debugNeuralization) {
            new NeuralDebugger(this.settings).addDebugStream(pipeline);
        }
        return pipeline;
    }

    public Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> buildProcessingPipeline() {
        Pipe pipe;
        Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> pipeline = new Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>>("NeuralNetsPostprocessingPipeline", this.settings);
        Pipe nextPipe = pipeline.registerStart(new IdentityGenPipe("NNBuildingInit"));
        if (this.settings.aggregateConflictingQueries) {
            pipe = pipeline.registerEnd(new SameQueryAggregationPipe(this.settings));
            nextPipe.connectAfter(pipe);
            nextPipe = pipe;
        }
        if (this.settings.neuralNetsSupervisedPruning) {
            // empty if block
        }
        if (this.settings.copyOutInputOvermapping) {
            // empty if block
        }
        if (this.settings.cycleBreaking) {
            pipe = pipeline.registerEnd(new CycleBreakingPipe(this.settings));
            nextPipe.connectAfter(pipe);
            nextPipe = pipe;
        }
        if (this.settings.chainPruning) {
            PruningPipe pruningPipe = pipeline.registerEnd(new PruningPipe(this.settings));
            nextPipe.connectAfter(pruningPipe);
            nextPipe = pruningPipe;
        }
        if (this.settings.isoValueCompression) {
            CompressionPipe isoValuePipe = pipeline.registerEnd(new CompressionPipe(this.settings));
            nextPipe.connectAfter(isoValuePipe);
            nextPipe = isoValuePipe;
        }
        if (this.settings.isoGradientCompression) {
            // empty if block
        }
        if (this.settings.mergeIdenticalWeightedInputs || this.settings.removeIdenticalUnweightedInputs) {
            EdgeMergerPipe edgeMergerPipe = pipeline.registerEnd(new EdgeMergerPipe(this.settings));
            nextPipe.connectAfter(edgeMergerPipe);
            nextPipe = edgeMergerPipe;
        }
        if (this.settings.collapseWeights) {
            // empty if block
        }
        if (this.settings.expandEmbeddings) {
            // empty if block
        }
        return pipeline;
    }
}

