/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.logic.constructs.building.factories.WeightFactory;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.grounding.GroundingSample;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.building.GroundingBuilder;
import cz.cvut.fel.ida.pipelines.building.NeuralNetsBuilder;
import cz.cvut.fel.ida.pipelines.building.TemplateSamplesBuilder;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.pipes.generic.LambdaPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.TemplateToNeuralPipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import java.util.stream.Stream;

public class PythonBuilder {
    private final WeightFactory weightFactory;
    private final Settings settings;
    private final PythonGroundingPipeline groundingPipeline;
    private final PythonNeuralizationPipeline neuralizationPipeline;

    public PythonBuilder(Settings settings) {
        this.settings = settings;
        this.weightFactory = new WeightFactory(settings.inferred.maxWeightCount);
        this.groundingPipeline = new PythonGroundingPipeline(settings);
        this.neuralizationPipeline = new PythonNeuralizationPipeline(settings);
    }

    public Pipe<Template, NeuralModel> convertModel() {
        return new TemplateToNeuralPipe(this.settings);
    }

    public Pipeline<Sources, Pair<Template, Stream<LogicSample>>> buildFromSources(Template template, Sources sources, Settings settings) {
        TemplateSamplesBuilder templateSamplesBuilder = new TemplateSamplesBuilder(sources, settings, template);
        return templateSamplesBuilder.buildPipeline();
    }

    public Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> buildGrounding(Settings settings, WeightFactory weightFactory) {
        GroundingBuilder groundingBuilder = new GroundingBuilder(settings, weightFactory);
        return groundingBuilder.buildPipeline();
    }

    public Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> buildNeuralNets(Settings settings, WeightFactory weightFactory) {
        NeuralNetsBuilder neuralNetsBuilder = new NeuralNetsBuilder(settings, weightFactory);
        return neuralNetsBuilder.buildPipeline();
    }

    public Template buildTemplate(Sources sources) throws Exception {
        TemplateSamplesBuilder templateSamplesBuilder = new TemplateSamplesBuilder(sources, this.settings);
        return (Template)templateSamplesBuilder.getSourcesTemplatePipeline((Sources)sources, (Settings)this.settings).execute((Sources)sources).s;
    }

    public Pipeline<Sources, Stream<GroundingSample>> buildGroundings(Template template, Stream<LogicSample> logicSamples, IntConsumer progressCallback) {
        return this.groundingPipeline.buildPipeline(template, logicSamples, progressCallback);
    }

    public Pipeline<Sources, Stream<GroundingSample>> buildGroundings(Template template, Sources sources, IntConsumer progressCallback) {
        return this.groundingPipeline.buildPipeline(template, sources, progressCallback);
    }

    public Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> neuralize(Stream<GroundingSample> groundings, IntConsumer progressCallback) {
        return this.neuralizationPipeline.buildPipeline(groundings, progressCallback);
    }

    class PythonNeuralizationPipeline
    extends AbstractPipelineBuilder<Stream<GroundingSample>, Stream<NeuralSample>> {
        public PythonNeuralizationPipeline(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> buildPipeline() {
            return null;
        }

        public Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> buildPipeline(Stream<GroundingSample> groundings, IntConsumer callback) {
            Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> neuralizationPipeline;
            Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> pipeline = new Pipeline<Stream<GroundingSample>, Stream<NeuralSample>>("PythonGroundingbBuilding", this);
            LambdaPipe<Stream, Stream> groundingIdentityPipe = pipeline.registerStart(new LambdaPipe<Stream, Stream>("NeuralizationIdentityPipe", s -> groundings, this.settings));
            if (callback != null) {
                neuralizationPipeline = pipeline.register(PythonBuilder.this.buildNeuralNets(this.settings, PythonBuilder.this.weightFactory));
                AtomicInteger counter = new AtomicInteger();
                LambdaPipe<Stream, Stream> progressCallbackPipe = pipeline.registerEnd(new LambdaPipe<Stream, Stream>("ProgressCallbackPipe", samples -> samples.peek(sample -> callback.accept(counter.incrementAndGet())), this.settings));
                neuralizationPipeline.connectAfter(progressCallbackPipe);
            } else {
                neuralizationPipeline = pipeline.registerEnd(PythonBuilder.this.buildNeuralNets(this.settings, PythonBuilder.this.weightFactory));
            }
            groundingIdentityPipe.connectAfter(neuralizationPipeline);
            return pipeline;
        }
    }

    class PythonGroundingPipeline
    extends AbstractPipelineBuilder<Sources, Stream<GroundingSample>> {
        public PythonGroundingPipeline(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Sources, Stream<GroundingSample>> buildPipeline() {
            return null;
        }

        public Pipeline<Sources, Stream<GroundingSample>> buildPipeline(Template template, Stream<LogicSample> logicSamples, IntConsumer callback) {
            Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> groundingPipeline;
            Pipeline<Sources, Stream<GroundingSample>> pipeline = new Pipeline<Sources, Stream<GroundingSample>>("PythonGroundingBuilding", this);
            LambdaPipe<Sources, Pair> templateIdentityPipe = pipeline.registerStart(new LambdaPipe<Sources, Pair>("TemplateIdentityPipe", s -> new Pair<Template, Stream>(template, logicSamples), this.settings));
            if (callback != null) {
                groundingPipeline = pipeline.register(PythonBuilder.this.buildGrounding(this.settings, PythonBuilder.this.weightFactory));
                AtomicInteger counter = new AtomicInteger();
                LambdaPipe<Stream, Stream> progressCallbackPipe = pipeline.registerEnd(new LambdaPipe<Stream, Stream>("ProgressCallbackPipe", samples -> samples.peek(sample -> callback.accept(counter.incrementAndGet())), this.settings));
                groundingPipeline.connectAfter(progressCallbackPipe);
            } else {
                groundingPipeline = pipeline.registerEnd(PythonBuilder.this.buildGrounding(this.settings, PythonBuilder.this.weightFactory));
            }
            templateIdentityPipe.connectAfter(groundingPipeline);
            return pipeline;
        }

        public Pipeline<Sources, Stream<GroundingSample>> buildPipeline(Template template, Sources sources, IntConsumer callback) {
            Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> groundingPipeline;
            Pipeline<Sources, Stream<GroundingSample>> pipeline = new Pipeline<Sources, Stream<GroundingSample>>("PythonGroundingBuilding", this);
            Pipeline<Sources, Pair<Template, Stream<LogicSample>>> sourcesPairPipeline = pipeline.registerStart(PythonBuilder.this.buildFromSources(template, sources, this.settings));
            if (callback != null) {
                groundingPipeline = pipeline.register(PythonBuilder.this.buildGrounding(this.settings, PythonBuilder.this.weightFactory));
                AtomicInteger counter = new AtomicInteger();
                LambdaPipe<Stream, Stream> progressCallbackPipe = pipeline.registerEnd(new LambdaPipe<Stream, Stream>("ProgressCallbackPipe", samples -> samples.peek(sample -> callback.accept(counter.incrementAndGet())), this.settings));
                groundingPipeline.connectAfter(progressCallbackPipe);
            } else {
                groundingPipeline = pipeline.registerEnd(PythonBuilder.this.buildGrounding(this.settings, PythonBuilder.this.weightFactory));
            }
            sourcesPairPipeline.connectAfter(groundingPipeline);
            return pipeline;
        }
    }
}

