/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.learning.results.Results;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.grounding.GroundingSample;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.pipelines.Branch;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.building.GroundingBuilder;
import cz.cvut.fel.ida.pipelines.building.NeuralNetsBuilder;
import cz.cvut.fel.ida.pipelines.building.SamplesProcessingBuilder;
import cz.cvut.fel.ida.pipelines.building.TemplateProcessingBuilder;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.pipes.generic.DuplicateBranch;
import cz.cvut.fel.ida.pipelines.pipes.generic.PairMerge;
import cz.cvut.fel.ida.pipelines.pipes.specific.NeuralEvaluationPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.TemplateToNeuralPipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Source;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class TestingBuilder
extends AbstractPipelineBuilder<Sources, Results> {
    private static final Logger LOG = Logger.getLogger(TestingBuilder.class.getName());
    Sources sources;

    public TestingBuilder(Settings settings, Sources sources) {
        super(settings);
        this.sources = sources;
    }

    @Override
    public Pipeline<Sources, Results> buildPipeline() {
        return this.buildPipeline(this.sources);
    }

    public Pipeline<Sources, Results> buildPipeline(Sources sources) {
        Pipeline<Sources, Results> pipeline = new Pipeline<Sources, Results>("TestingPipeline", this);
        DuplicateBranch duplicateSources = pipeline.registerStart(new DuplicateBranch());
        1 getTestSourcePipe = pipeline.register(new Pipe<Sources, Source>("getTestSourcePipe"){

            @Override
            public Source apply(Sources sources) {
                return sources.test;
            }
        });
        Pipeline<Source, Stream<LogicSample>> testSampleStream = pipeline.register(new SamplesProcessingBuilder(this.settings, sources.test).buildPipeline());
        Pipeline<Sources, Template> templatePipeline = pipeline.register(new TemplateProcessingBuilder(this.settings, sources).buildPipeline());
        DuplicateBranch duplicateTemplate = pipeline.register(new DuplicateBranch());
        TemplateToNeuralPipe templateToNeuralPipe = pipeline.register(new TemplateToNeuralPipe(this.settings));
        PairMerge pairMerge = pipeline.register(new PairMerge());
        TestingBuilder testingBuilder = new TestingBuilder(this.settings, sources);
        Objects.requireNonNull(testingBuilder);
        LogicTestingBuilder testingBuilder2 = testingBuilder.new LogicTestingBuilder(this.settings);
        Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> logicTestingPipeline = pipeline.registerEnd(testingBuilder2.buildPipeline());
        PairMerge modelMerge = pipeline.register(new PairMerge());
        duplicateSources.connectAfterL(getTestSourcePipe);
        duplicateSources.connectAfterR(templatePipeline);
        getTestSourcePipe.connectAfter(testSampleStream);
        templatePipeline.connectAfter(duplicateTemplate);
        duplicateTemplate.connectAfterL(templateToNeuralPipe);
        modelMerge.connectBeforeL(duplicateTemplate.output2);
        modelMerge.connectBeforeR(templateToNeuralPipe);
        pairMerge.connectBeforeL(modelMerge);
        pairMerge.connectBeforeR(testSampleStream);
        pairMerge.connectAfter(logicTestingPipeline);
        return pipeline;
    }

    public class NeuralTestingBuilder
    extends AbstractPipelineBuilder<Pair<NeuralModel, Stream<NeuralSample>>, Results> {
        public NeuralTestingBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> buildPipeline() {
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> pipeline = new Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results>("NeuralTestingPipeline", this);
            NeuralEvaluationPipe neuralEvaluationPipe = pipeline.registerEnd(pipeline.registerStart(new NeuralEvaluationPipe(this.settings)));
            return pipeline;
        }
    }

    public class LogicTestingBuilder
    extends AbstractPipelineBuilder<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> {
        Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> groundingPipeline;
        Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> neuralizationPipeline;
        Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> neuralTestingPipeline;

        public LogicTestingBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> buildPipeline() {
            Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> pipeline = new Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results>("LogicTestingPipeline", this);
            if (this.groundingPipeline == null) {
                GroundingBuilder groundingBuilder = new GroundingBuilder(this.settings);
                this.groundingPipeline = pipeline.register(groundingBuilder.buildPipeline());
                NeuralNetsBuilder neuralNetsBuilder = new NeuralNetsBuilder(this.settings, groundingBuilder.weightFactory);
                this.neuralizationPipeline = pipeline.register(neuralNetsBuilder.buildPipeline());
            }
            if (this.neuralTestingPipeline == null) {
                NeuralTestingBuilder neuralTestingBuilder = new NeuralTestingBuilder(this.settings);
                this.neuralTestingPipeline = pipeline.registerEnd(neuralTestingBuilder.buildPipeline());
            }
            1 modelSplitBranch = pipeline.registerStart(new Branch<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Pair<Template, Stream<LogicSample>>, NeuralModel>("ModelSplitBranch"){

                @Override
                protected Pair<Pair<Template, Stream<LogicSample>>, NeuralModel> branch(Pair<Pair<Template, NeuralModel>, Stream<LogicSample>> input) {
                    return new Pair<Pair<Template, Stream<LogicSample>>, NeuralModel>(new Pair<Template, Stream>((Template)((Pair)input.r).r, (Stream)input.s), (NeuralModel)((Pair)input.r).s);
                }
            });
            modelSplitBranch.connectAfterL(this.groundingPipeline);
            this.groundingPipeline.connectAfter(this.neuralizationPipeline);
            PairMerge testMerge = pipeline.register(new PairMerge());
            testMerge.connectBeforeL(modelSplitBranch.output2);
            testMerge.connectBeforeR(this.neuralizationPipeline);
            testMerge.connectAfter(this.neuralTestingPipeline);
            return pipeline;
        }
    }
}

