/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.debugging;

import cz.cvut.fel.ida.drawing.Drawer;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.building.End2endTrainigBuilder;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.debuging.drawing.PipelineDrawer;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.exporting.Exporter;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Stream;

public abstract class End2EndDebugger<S extends Exportable>
extends AbstractPipelineBuilder<Sources, Stream<S>> {
    private static final Logger LOG = Logger.getLogger(End2EndDebugger.class.getName());
    S debuggingInput;
    protected Pipeline<Sources, Stream<S>> pipeline = null;
    public Drawer<S> drawer;
    protected Sources sources;
    protected End2endTrainigBuilder end2endTrainigBuilder;
    protected boolean intermediateDebug;
    protected boolean exporting;
    protected boolean drawing;
    protected Exporter exporter;

    public End2EndDebugger(Settings settings) {
        super(settings);
        this.drawing = settings.drawing;
        this.exporting = settings.debugExporting;
        this.intermediateDebug = settings.intermediateDebug;
        if (this.exporting) {
            this.startExport();
        }
    }

    public End2EndDebugger(Sources sources, Settings settings) {
        super(settings);
        this.sources = sources;
        this.end2endTrainigBuilder = new End2endTrainigBuilder(settings, sources);
        this.pipeline = new Pipeline(this.getClass().getSimpleName() + "Pipeline", this);
        this.intermediateDebug = settings.intermediateDebug;
        this.exporting = settings.debugExporting;
        if (this.exporting) {
            this.startExport();
        }
        this.drawing = settings.drawing;
    }

    public Pair<String, Stream<S>> executeDebug() throws Exception {
        this.pipeline = this.buildPipeline();
        if (this.settings.debugPipeline) {
            this.drawPipeline();
        }
        this.addDebugTerminal(this.pipeline);
        return this.pipeline.execute(this.sources);
    }

    public void addDebugElement(Pipeline<?, S> pipeline) {
        pipeline.registerEnd(pipeline.terminal.connectAfter(new Pipe<S, S>("PeekPipe"){

            @Override
            public S apply(S s) {
                End2EndDebugger.this.debug(s);
                return s;
            }
        }));
    }

    public void addDebugStream(Pipeline<?, Stream<S>> pipeline) {
        pipeline.registerEnd(pipeline.terminal.connectAfter(new Pipe<Stream<S>, Stream<S>>("PeekPipe"){

            @Override
            public Stream<S> apply(Stream<S> stream) {
                return stream.peek(s -> {
                    if (End2EndDebugger.this.exporting) {
                        End2EndDebugger.this.exportSample(s);
                    }
                    End2EndDebugger.this.debug(s);
                });
            }
        }));
    }

    public void addDebugTerminal(Pipeline<?, Stream<S>> pipeline) {
        pipeline.registerEnd(pipeline.terminal.connectAfter(new Pipe<Stream<S>, Stream<S>>("StreamTerminationPipe"){

            @Override
            public Stream<S> apply(Stream<S> stream) {
                stream.forEach(new Consumer<S>(){

                    @Override
                    public void accept(S s) {
                        if (End2EndDebugger.this.exporting) {
                            End2EndDebugger.this.exportSample(s);
                        }
                        End2EndDebugger.this.debug(s);
                    }
                });
                End2EndDebugger.this.endExport();
                return stream;
            }
        }));
    }

    public void drawPipeline() {
        PipelineDrawer pipelineDrawer = new PipelineDrawer(this.settings);
        pipelineDrawer.draw(this.pipeline);
    }

    public Pipeline<Sources, Stream<S>> getPipeline() {
        return this.pipeline;
    }

    public abstract void debug(S var1);

    protected void exportSample(S sample) {
        this.exporter.export((Exportable)sample);
        if (this.settings.exportType == Settings.ExportFileType.JSON) {
            this.exporter.delimitNext();
        }
    }

    protected void startExport() {
        this.exporter = Exporter.getExporter(Paths.get(this.settings.exportDir, "debug").toString(), this.getClass().getSimpleName(), this.settings.exportType.name());
        if (this.settings.exportType == Settings.ExportFileType.JSON) {
            this.exporter.delimitStart();
        }
    }

    protected void endExport() {
        if (this.settings.exportType == Settings.ExportFileType.JSON) {
            this.exporter.delimitEnd();
        }
        this.exporter.finish();
    }
}

