/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.debugging.drawing;

import cz.cvut.fel.ida.drawing.Drawer;
import cz.cvut.fel.ida.drawing.GraphViz;
import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.constructs.template.types.GraphTemplate;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import cz.cvut.fel.ida.setup.Settings;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TemplateDrawer
extends Drawer<Template> {
    Set<String> graph;

    public TemplateDrawer(Settings settings) {
        super(settings);
    }

    @Override
    public void loadGraph(Template obj) {
        this.graph = new LinkedHashSet<String>();
        this.graphviz.start_graph();
        if (obj instanceof GraphTemplate) {
            this.loadGraph((GraphTemplate)obj);
        } else {
            this.loadGraph(new GraphTemplate(obj));
        }
        this.graph.forEach(this.graphviz::addln);
        this.graphviz.end_graph();
    }

    @Override
    public void loadGraph(GraphTemplate obj) {
        Map<Literal, Set<WeightedRule>> atom2rules = obj.atom2rules;
        LinkedHashSet facts = obj.facts;
        Matching matching = new Matching(Collections.singletonList(new Clause(facts.stream().map(f -> f.literal).collect(Collectors.toSet()))));
        HashMap<Predicate, Set> pred2facts = new HashMap<Predicate, Set>();
        for (ValuedFact valuedFact : facts) {
            this.graph.add(this.draw(valuedFact));
            Set factSet = pred2facts.computeIfAbsent(valuedFact.literal.predicate(), k -> new HashSet());
            factSet.add(valuedFact);
        }
        for (Map.Entry entry : atom2rules.entrySet()) {
            Literal literal = (Literal)entry.getKey();
            Set rules = (Set)entry.getValue();
            this.graph.add(this.draw(literal));
            for (WeightedRule rule : rules) {
                this.graph.add(this.draw(rule));
                this.graph.add(this.draw(literal, rule));
                for (BodyAtom bodyAtom : rule.getBody()) {
                    this.graph.add(this.draw(bodyAtom));
                    this.graph.add(this.draw(rule, bodyAtom));
                    Set matchedFacts = (Set)pred2facts.get(bodyAtom.literal.predicate());
                    if (matchedFacts == null) continue;
                    for (ValuedFact matchedFact : matchedFacts) {
                        if (!matching.subsumption(new Clause(matchedFact.literal), new Clause(bodyAtom.literal)).booleanValue() && !matching.subsumption(new Clause(bodyAtom.literal), new Clause(matchedFact.literal)).booleanValue()) continue;
                        this.graph.add(this.draw(bodyAtom, matchedFact));
                    }
                }
            }
        }
    }

    private String draw(WeightedRule rule, BodyAtom bodyAtom) {
        String edgeColor = bodyAtom.isNegated() ? "red" : "black";
        String weight = bodyAtom.getConjunctWeight() == null ? "" : bodyAtom.getConjunctWeight().toString(this.numberFormat);
        return bodyAtom.literal.liftedHashCode() + " -> " + rule.hashCode() + "[label=" + GraphViz.sanitize(weight) + ", color=" + edgeColor + "]";
    }

    private String draw(BodyAtom bodyAtom) {
        return this.draw(bodyAtom.literal);
    }

    private String draw(Literal literal, WeightedRule rule) {
        String weight = rule.getWeight() != null ? GraphViz.sanitize(rule.getWeight().toString(this.numberFormat)) : "null : 1";
        return rule.hashCode() + " -> " + literal.liftedHashCode() + "[label=" + weight + ", color=green, style=dashed]";
    }

    private String draw(BodyAtom bodyAtom, ValuedFact matchedFact) {
        return matchedFact.literal.liftedHashCode() + " -> " + bodyAtom.literal.liftedHashCode() + "[dir=both, style=dotted, color=blue]";
    }

    private String draw(Literal literal) {
        String name = literal.toString();
        if (literal.isNegated()) {
            name = name.substring(1);
        }
        return literal.liftedHashCode() + "[label=" + GraphViz.sanitize(name) + "]";
    }

    private String draw(WeightedRule rule) {
        return rule.hashCode() + "[label=" + GraphViz.sanitize(rule.getOriginalString()) + ", shape=larrow, color=green]";
    }

    private String draw(ValuedFact fact) {
        return fact.literal.liftedHashCode() + "[shape=house, label=" + GraphViz.sanitize(fact.toString()) + "]";
    }
}

