/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.pipes.specific;

import cz.cvut.fel.ida.neural.networks.structure.building.NeuralNetBuilder;
import cz.cvut.fel.ida.neural.networks.structure.building.NeuralProcessingSample;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.QueryNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.types.DetailedNetwork;
import cz.cvut.fel.ida.neural.networks.structure.transforming.NetworkReducing;
import cz.cvut.fel.ida.neural.networks.structure.transforming.ParentsExtractor;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.setup.Settings;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetworkFinalizationPipe
extends Pipe<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> {
    private static final Logger LOG = Logger.getLogger(NetworkFinalizationPipe.class.getName());
    private final NeuralNetBuilder neuralNetBuilder;

    public NetworkFinalizationPipe(Settings settings, NeuralNetBuilder neuralNetBuilder) {
        super("NetworksFinalizationPipe", settings);
        this.neuralNetBuilder = neuralNetBuilder;
    }

    @Override
    public Stream<NeuralProcessingSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
        if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL && this.settings.iterationMode == Settings.IterationMode.TOPOLOGIC) {
            neuralProcessingSampleStream = neuralProcessingSampleStream.map(sample -> {
                if (((QueryNeuron)sample.query).neuron != null) {
                    DetailedNetwork emptyCopy = sample.detailedNetwork.emptyCopy(sample.getId());
                    NetworkReducing.supervisedNetReconstruction(emptyCopy, Collections.singletonList(((QueryNeuron)sample.query).neuron));
                    sample.detailedNetwork = emptyCopy;
                    ((QueryNeuron)sample.query).evidence = emptyCopy;
                }
                return sample;
            });
        }
        if (this.settings.parentCounting && (this.settings.parallelTraining || !this.settings.neuralStreaming)) {
            ParentsExtractor parentsExtractor = new ParentsExtractor();
            List<NeuralProcessingSample> processingSamples = neuralProcessingSampleStream.collect(Collectors.toList());
            processingSamples.forEach(sample -> parentsExtractor.extractSharedNeuronsParents(sample.detailedNetwork));
            neuralProcessingSampleStream = processingSamples.stream();
        }
        return neuralProcessingSampleStream.map(sample -> {
            sample.detailedNetwork = this.neuralNetBuilder.neuralBuilder.statesBuilder.setupFinalStatesCache(sample.detailedNetwork);
            return sample;
        });
    }
}

