/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.pipes.specific;

import cz.cvut.fel.ida.learning.results.DetailedClassificationResults;
import cz.cvut.fel.ida.learning.results.Result;
import cz.cvut.fel.ida.learning.results.Results;
import cz.cvut.fel.ida.learning.results.VoidResults;
import cz.cvut.fel.ida.neural.networks.computation.iteration.actions.Evaluation;
import cz.cvut.fel.ida.neural.networks.computation.iteration.actions.IndependentNeuronProcessing;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states.neurons.Invalidator;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.QueryNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeurons;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.TextExporter;
import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.generic.Utilities;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class NeuralEvaluationPipe
extends Pipe<Pair<NeuralModel, Stream<NeuralSample>>, Results> {
    private static final Logger LOG = Logger.getLogger(NeuralEvaluationPipe.class.getName());
    Settings settings;
    private static int counter = 1;

    public NeuralEvaluationPipe(Settings settings) {
        super("NeuralEvaluationPipe");
        this.settings = settings;
    }

    @Override
    public Results apply(Pair<NeuralModel, Stream<NeuralSample>> neuralModelStreamPair) {
        VoidResults results;
        IndependentNeuronProcessing invalidation = new IndependentNeuronProcessing(this.settings, new Invalidator(-1));
        Evaluation evaluation = new Evaluation(this.settings);
        List<NeuralSample> collect = Utilities.terminateSampleStream((Stream)neuralModelStreamPair.s);
        ArrayList<Result> resultList = new ArrayList<Result>();
        for (NeuralSample neuralSample : collect) {
            NeuralNetwork neuralNetwork = (NeuralNetwork)((QueryNeuron)neuralSample.query).evidence;
            AtomNeurons neuron = ((QueryNeuron)neuralSample.query).neuron;
            ((NeuralNetwork)((QueryNeuron)neuralSample.query).evidence).initializeStatesCache(-1);
            invalidation.process(neuralNetwork, neuron);
            Result evaluate = evaluation.evaluate(neuralSample);
            resultList.add(evaluate);
        }
        if (((Result)resultList.get(0)).getTarget() != null) {
            Results.Factory factory = Results.Factory.getFrom(this.settings.testResultsType, this.settings);
            results = factory.createFrom(resultList);
        } else {
            results = new VoidResults(resultList, this.settings);
        }
        NeuralModel neuralModel = (NeuralModel)neuralModelStreamPair.r;
        if (neuralModel.threshold != null && results instanceof DetailedClassificationResults) {
            ((DetailedClassificationResults)((Object)results)).computeBestAccuracy(results.evaluations, neuralModel.threshold);
        }
        LOG.finer("Testing outputs");
        LOG.fine(((Results)results).toString(this.settings));
        LOG.finer(results.printOutputs(false).toString());
        TextExporter.exportString(results.printOutputs(true).toString(), Paths.get(this.settings.exportDir, "outputs/test" + counter++ + ".txt"));
        return results;
    }
}

