/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.pipes.specific;

import cz.cvut.fel.ida.learning.results.Progress;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.neural.networks.computation.training.strategies.TrainingStrategy;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.debugging.NeuralDebugger;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class NeuralTrainingPipe
extends Pipe<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> {
    private static final Logger LOG = Logger.getLogger(NeuralTrainingPipe.class.getName());
    Settings settings;
    TrainingStrategy trainingStrategy;

    public NeuralTrainingPipe(Settings settings) {
        super("NeuralTrainingPipe");
        this.settings = settings;
    }

    protected NeuralTrainingPipe(String id) {
        super(id);
    }

    @Override
    public Pair<NeuralModel, Progress> apply(Pair<NeuralModel, Stream<NeuralSample>> neuralModelStreamPair) {
        NeuralModel model = (NeuralModel)neuralModelStreamPair.r;
        Stream sampleStream = (Stream)neuralModelStreamPair.s;
        this.trainingStrategy = TrainingStrategy.getFrom(this.settings, model, sampleStream);
        this.trainingStrategy.setupDebugger(new NeuralDebugger(this.settings));
        Pair<NeuralModel, Progress> training = this.trainingStrategy.train();
        return training;
    }

    @Override
    protected <T> void export(T outputReady) {
        if (this.exporter == null && this.parent != null) {
            this.exporter = NeuralTrainingPipe.createExporter(this.ID, this.parent.settings);
        }
        if (this.exporter != null) {
            this.trainingStrategy.export(this.exporter);
        }
    }
}

