/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.pipes.specific;

import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.neural.networks.structure.building.NeuralProcessingSample;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.QueryNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.types.AtomNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.types.DetailedNetwork;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Utilities;
import cz.cvut.fel.ida.utils.math.collections.MultiList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SameQueryAggregationPipe
extends Pipe<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> {
    private static final Logger LOG = Logger.getLogger(SameQueryAggregationPipe.class.getName());
    Aggregation aggregation;

    public SameQueryAggregationPipe(Settings settings) {
        super("QueryFilteringPipe", settings);
        this.aggregation = Aggregation.getFunction(settings.factMergeActivation);
    }

    @Override
    public Stream<NeuralProcessingSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
        if (this.settings.oneQueryPerExample) {
            return neuralProcessingSampleStream;
        }
        List<NeuralProcessingSample> processingSamples = Utilities.terminateSampleStream(neuralProcessingSampleStream);
        LinkedList<NeuralProcessingSample> outputProcessingSamples = new LinkedList<NeuralProcessingSample>();
        MultiList<DetailedNetwork, NeuralProcessingSample> sampleMap = new MultiList<DetailedNetwork, NeuralProcessingSample>();
        for (NeuralProcessingSample neuralProcessingSample : processingSamples) {
            sampleMap.put(neuralProcessingSample.detailedNetwork, neuralProcessingSample);
        }
        for (Map.Entry entry : sampleMap.entrySet()) {
            List samples = (List)entry.getValue();
            MultiList<AtomNeuron<Object>, NeuralProcessingSample> singleExampleMap = new MultiList<AtomNeuron<Object>, NeuralProcessingSample>();
            for (NeuralProcessingSample neuralProcessingSample : samples) {
                AtomNeuron<Object> neuron = ((QueryNeuron)neuralProcessingSample.query).neuron;
                if (neuron == null) {
                    LOG.info("Samples without query neurons encountered during SameQueryAggregation");
                    neuron = new AtomNeuron<Object>(((QueryNeuron)neuralProcessingSample.query).ID, ((QueryNeuron)neuralProcessingSample.query).position, null);
                }
                singleExampleMap.put(neuron, neuralProcessingSample);
            }
            for (Map.Entry entry2 : singleExampleMap.entrySet()) {
                outputProcessingSamples.add(this.mergeSamples((List)entry2.getValue()));
            }
        }
        return outputProcessingSamples.stream();
    }

    private NeuralProcessingSample mergeSamples(List<NeuralProcessingSample> sameQuerySamples) {
        List<Value> values = sameQuerySamples.stream().map(s -> s.target).collect(Collectors.toList());
        Value merge = this.aggregation.evaluate(values);
        NeuralProcessingSample result = sameQuerySamples.get(0);
        result.target = merge;
        return result;
    }
}

