/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.setup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;

public class Settings
implements Serializable {
    private static final transient Logger LOG = Logger.getLogger(Settings.class.getName());
    public static final OS os = Settings.getOs();
    private static File referenceSettingsFile;
    public static String inputFilesSuffix;
    public static boolean htmlLogging;
    public static boolean supressConsoleOutput;
    public static boolean supressLogFileOutput;
    public static Level loggingLevel;
    public static boolean customLogColors;
    public static String logFile;
    public static int seed;
    public String graphvizPath = null;
    public String pythonPath = "python";
    public String progressPlotterPath = "../Frontend/grid/loading_results.py";
    public ExportFileType exportType = ExportFileType.JSON;
    public boolean cleanUpFirst = true;
    public String outDir = "./target/out";
    public String resultFile;
    public String settingsExportFile;
    public String sourcesExportFile;
    public String console;
    public String exportDir;
    public String[] exportBlocks = new String[]{"TrainTestPipeline", "NeuralTrainTestPipeline", "NeuralEvaluationPipe", "CrossvalidationPipeline", "CompressionPipe", "NetworkPruningPipe", "NeuralTrainingPipe", "GroundingPipeline", "NeuralizationPipeline", "LearningSchemePipeline", "NeuralEvaluationPipe"};
    public boolean drawing = false;
    public boolean debugAll = false;
    public boolean debugPipeline = false;
    public boolean debugTemplate = false;
    public boolean debugGrounding = false;
    public boolean debugNeuralization = false;
    public boolean debugSampleTraining = false;
    public boolean debugTemplateTraining = false;
    public boolean debugSampleOutputs = false;
    public boolean intermediateDebug;
    public boolean debugExporting = true;
    public Detail drawingDetail = Detail.HIGH;
    public String imageFile = this.outDir + "/graph";
    public String graphVizAlgorithm = "dot";
    public String imgType = "png";
    public boolean fix2ScreenSize = false;
    public boolean storeNotShow = false;
    public boolean compactGroundingDrawing;
    public Optimize optimize = Optimize.SPEED;
    public transient Random random;
    private static transient DecimalFormatSymbols decimalFormatSymbol;
    public static transient NumberFormat superDetailedNumberFormat;
    public static transient NumberFormat detailedNumberFormat;
    public static transient NumberFormat shortNumberFormat;
    public static transient NumberFormat defaultNumberFormat;
    public MainMode mainMode = MainMode.COMPLETE;
    public boolean rebuildPipelines = false;
    public int appLimitSamples = -1;
    public boolean trainTestJointGrounding;
    public GroundingMode groundingMode = GroundingMode.INDEPENDENT;
    public boolean possibleNeuronSharing = false;
    public boolean parallelGrounding = false;
    public GroundingAlgo grounding = GroundingAlgo.BUP;
    public CombinationFcn factMergeActivation = CombinationFcn.MAX;
    public boolean uniqueGroundingsOnly = true;
    public boolean aggregateConflictingQueries = true;
    public boolean explicitSupervisedGroundTemplatePruning = false;
    public boolean forceFullNetworks = false;
    public double defaultFactValue = 1.0;
    public boolean ruleAdaptiveOffset = false;
    public double defaultRuleNeuronOffset = 0.0;
    public double defaultAtomNeuronOffset = 0.0;
    public boolean defaultRuleOffsetsLearnable = false;
    public boolean defaultAtomOffsetsLearnable = false;
    public boolean neuralNetsPostProcessing = true;
    public boolean neuralNetsSupervisedPruning;
    public boolean copyOutInputOvermapping;
    public boolean calculateOutputLinks;
    public boolean cycleBreaking;
    public boolean chainPruning = true;
    public boolean isoValueCompression = true;
    public boolean structuralIsoCompression = false;
    public boolean isoGradientCompression;
    public boolean mergeIdenticalWeightedInputs = false;
    public boolean removeIdenticalUnweightedInputs = false;
    public boolean collapseActivations;
    public boolean collapseWeights;
    public boolean expandEmbeddings;
    public NeuralState neuralState = NeuralState.STANDARD;
    public boolean parentCounting;
    public boolean fullRuleNeuronStrings = false;
    public boolean fullAggNeuronStrings = false;
    public boolean pruneEvenWeightedNeurons = false;
    public boolean pruneOnlyIdentities = false;
    public int isoValueInits = 1;
    public int isoDecimals = 12;
    public int plotProgress = -1;
    public ResultsType trainOnlineResultsType = ResultsType.CLASSIFICATION;
    public ResultsType trainRecalculationResultsType = ResultsType.DETAILEDCLASSIFICATION;
    public ResultsType validationResultsType = ResultsType.DETAILEDCLASSIFICATION;
    public ResultsType testResultsType = ResultsType.DETAILEDCLASSIFICATION;
    public boolean alternativeAUC = false;
    public int resultsRecalculationEpochae = 10;
    public NeuronSearch neuronSearch = NeuronSearch.LINEAR;
    public int lin2bst = 9;
    public int bst2hashmap = 12;
    public int minibatchSize = 1;
    public boolean asyncParallelTraining;
    public boolean parallelTraining;
    public boolean neuralStreaming;
    public int restartCount = 5;
    public boolean earlyStopping = false;
    public int maxCumEpochCount = 3000;
    public int earlyStoppingPatience = 100;
    public boolean shuffleBeforeTraining = true;
    public boolean shuffleEachEpoch = true;
    public boolean islearnRateDecay = false;
    public int decaySteps = 100;
    public double learnRateDecay = 0.95;
    public DecaySet decaySet = DecaySet.GEOMETRIC;
    public InitSet initializer = InitSet.SIMPLE;
    public InitDistribution initDistribution = InitDistribution.UNIFORM;
    public double randomInitScale = 2.0;
    public boolean checkNeuronSaturation = true;
    public double saturationPercentage = 0.3;
    public double constantInitValue = 0.1;
    public double initLearningRate = 0.001;
    public double dropoutRate = 0.0;
    private OptimizerSet optimizer = OptimizerSet.ADAM;
    public DropoutMode dropoutMode = DropoutMode.LIFTED_DROPCONNECT;
    public boolean calculateBestThreshold = true;
    public ErrorFcn errorFunction = ErrorFcn.SQUARED_DIFF;
    public boolean inferOutputFcns = true;
    public boolean squishLastLayer = true;
    public boolean hitsReifyPredicate = false;
    public HitsCorruption hitsCorruption = HitsCorruption.ONE_DIFF;
    public boolean storeHitsCorruptions = true;
    public HitsPreservation hitsPreservation = HitsPreservation.NONE;
    public HitsClashes hitsClashes = HitsClashes.AVG;
    public boolean passResultsCache = false;
    public CombinationFcn errorAggregationFcn = CombinationFcn.AVG;
    public CombinationFcn ruleNeuronCombination = CombinationFcn.SUM;
    public TransformationFcn ruleNeuronTransformation = TransformationFcn.TANH;
    public CombinationFcn atomNeuronCombination = CombinationFcn.SUM;
    public TransformationFcn atomNeuronTransformation = TransformationFcn.TANH;
    public CombinationFcn aggNeuronAggregation = CombinationFcn.AVG;
    public TransformationFcn softNegation = TransformationFcn.REVERSE;
    public IterationMode iterationMode = IterationMode.TOPOLOGIC;
    public double trainValidationPercentage = 1.0;
    public boolean undoWeightTrainingChanges = false;
    public ModelSelection modelSelection = ModelSelection.ERROR;
    public DataSelection dataSelection = DataSelection.VALIDATION;
    public boolean exportTrainedModel = true;
    public boolean allowStructureLearning = false;
    public boolean structureLearning;
    public String sourcesFile = "sources.json";
    public String settingsFile = "settings.json";
    public boolean plaintextInput;
    public boolean sourceFiles = true;
    public boolean sourcePathProvided = false;
    public String sourcePath = ".";
    public String templateFile = "template" + inputFilesSuffix;
    public String templateFile2 = String.valueOf(Paths.get("templates", "template")) + inputFilesSuffix;
    public String mergedTemplatesSuffix = "_merged" + inputFilesSuffix;
    public String trainExamplesFile = "trainExamples" + inputFilesSuffix;
    public String trainExamplesFile2 = "examples" + inputFilesSuffix;
    public String valExamplesFile = "valExamples" + inputFilesSuffix;
    public String testExamplesFile = "testExamples" + inputFilesSuffix;
    public String trainQueriesFile = "trainQueries" + inputFilesSuffix;
    public String trainQueriesFile2 = "queries" + inputFilesSuffix;
    public String valQueriesFile = "valQueries" + inputFilesSuffix;
    public String testQueriesFile = "testQueries" + inputFilesSuffix;
    public String foldsPrefix = "fold_";
    public String queryExampleSeparator = ":-";
    public boolean crossvalidation;
    public boolean shuffleBeforeFoldSplit = true;
    public int foldsCount = 5;
    public boolean stratification = true;
    public boolean exportFolds = true;
    public boolean trainFoldsIsolation = false;
    public boolean checkStratification = true;
    public boolean processMetadata = true;
    public boolean graphTemplate = true;
    public boolean reduceTemplate = false;
    public boolean preprocessTemplateInference = true;
    public boolean supervisedTemplateGraphPruning = false;
    public boolean oneQueryPerExample = true;
    public boolean queriesAlignedWithExamples;
    public double defaultSampleImportance = 1.0;
    public String sampleIdPrefix = "s_";
    public String queriesBatchPrefix = "b_";
    public transient Inferred inferred = new Inferred();

    public String getChangesFromReference() {
        return "defaultParams";
    }

    public static OS getOs() {
        String osName = System.getProperty("os.name").replaceAll("\\s", "");
        if (osName.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("MacOSX")) {
            return OS.MACOSX;
        }
        if (osName.contains("Linux")) {
            return OS.LINUX;
        }
        return OS.LINUX;
    }

    public static Settings forFastTest() {
        Settings setting = new Settings();
        setting.drawing = false;
        setting.plotProgress = -1;
        setting.appLimitSamples = 2;
        seed = 0;
        setting.maxCumEpochCount = 2;
        setting.mainMode = MainMode.COMPLETE;
        setting.outDir = logFile;
        return setting;
    }

    public static Settings forMediumTest() {
        Settings setting = new Settings();
        setting.drawing = false;
        setting.plotProgress = -1;
        setting.appLimitSamples = -1;
        setting.maxCumEpochCount = 100;
        setting.resultsRecalculationEpochae = 100;
        seed = 0;
        setting.outDir = logFile;
        return setting;
    }

    public static Settings forSlowTest() {
        Settings setting = new Settings();
        setting.drawing = false;
        setting.plotProgress = -1;
        setting.appLimitSamples = -1;
        seed = 0;
        setting.outDir = logFile;
        return setting;
    }

    public static Settings forInteractiveTest() {
        Settings setting = new Settings();
        setting.drawing = true;
        setting.plotProgress = 1;
        setting.appLimitSamples = -1;
        seed = 0;
        setting.outDir = logFile;
        return setting;
    }

    public OptimizerSet getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(OptimizerSet iOptimizer) {
        switch (iOptimizer) {
            case SGD: {
                this.initLearningRate = 0.1;
                break;
            }
            case ADAM: {
                this.initLearningRate = 1.0E-4;
            }
        }
        this.optimizer = iOptimizer;
    }

    public static CombinationFcn parseCombination(String combination) {
        switch (combination.toLowerCase()) {
            case "avg": {
                return CombinationFcn.AVG;
            }
            case "max": {
                return CombinationFcn.MAX;
            }
            case "min": {
                return CombinationFcn.MIN;
            }
            case "sum": {
                return CombinationFcn.SUM;
            }
            case "count": {
                return CombinationFcn.COUNT;
            }
            case "product": {
                return CombinationFcn.PRODUCT;
            }
            case "elproduct": {
                return CombinationFcn.ELPRODUCT;
            }
            case "softmax": {
                return CombinationFcn.SOFTMAX;
            }
            case "sparsemax": {
                return CombinationFcn.SPARSEMAX;
            }
            case "crosssum": {
                return CombinationFcn.CROSSSUM;
            }
            case "concat": {
                return CombinationFcn.CONCAT;
            }
            case "cossim": {
                return CombinationFcn.COSSIM;
            }
        }
        throw new RuntimeException("Unable to parse combination function from: " + combination);
    }

    public static TransformationFcn parseTransformation(String transformation) {
        switch (transformation.toLowerCase()) {
            case "sigmoid": {
                return TransformationFcn.SIGMOID;
            }
            case "sigm": {
                return TransformationFcn.SIGMOID;
            }
            case "tanh": {
                return TransformationFcn.TANH;
            }
            case "signum": {
                return TransformationFcn.SIGNUM;
            }
            case "relu": {
                return TransformationFcn.RELU;
            }
            case "leakyrelu": {
                return TransformationFcn.LEAKYRELU;
            }
            case "identity": {
                return TransformationFcn.IDENTITY;
            }
            case "lukasiewicz": {
                return TransformationFcn.LUKASIEWICZ;
            }
            case "exp": {
                return TransformationFcn.EXP;
            }
            case "sqrt": {
                return TransformationFcn.SQRT;
            }
            case "inverse": {
                return TransformationFcn.INVERSE;
            }
            case "reverse": {
                return TransformationFcn.REVERSE;
            }
            case "log": {
                return TransformationFcn.LOGARITHM;
            }
            case "softmax": {
                return TransformationFcn.SOFTMAX;
            }
            case "sparsemax": {
                return TransformationFcn.SPARSEMAX;
            }
            case "transpose": {
                return TransformationFcn.TRANSP;
            }
            case "norm": {
                return TransformationFcn.NORM;
            }
            case "layernorm": {
                return TransformationFcn.NORM;
            }
        }
        throw new RuntimeException("Unable to parse transformation function from: " + transformation);
    }

    public Settings setupFromCommandline(CommandLine cmd) {
        String _fnc;
        String _limit;
        String _decay;
        Settings settings = this;
        if (cmd.hasOption("logColors")) {
            String logColors = cmd.getOptionValue("logColors");
            boolean bl = customLogColors = Integer.parseInt(logColors) > 0;
        }
        if (cmd.hasOption("settingsFile")) {
            String _settingsPath = cmd.getOptionValue("settings");
            settings = this.updateFromJson(Paths.get(_settingsPath, new String[0]));
        }
        if (cmd.hasOption("out")) {
            settings.outDir = cmd.getOptionValue("out");
        }
        if (cmd.hasOption("xval")) {
            String _xval = cmd.getOptionValue("xval", String.valueOf(this.foldsCount));
            settings.foldsCount = Integer.parseInt(_xval);
        }
        if (cmd.hasOption("seed")) {
            String _seed = cmd.getOptionValue("seed", String.valueOf(seed));
            seed = Integer.parseInt(_seed);
        }
        if (cmd.hasOption("groundingAlgorithm")) {
            String _groundingAlgorithm;
            switch (_groundingAlgorithm = cmd.getOptionValue("groundingAlgorithm", this.grounding.name())) {
                case "BUp": {
                    settings.grounding = GroundingAlgo.BUP;
                    break;
                }
                case "TDown": {
                    settings.grounding = GroundingAlgo.TDOWN;
                    break;
                }
                case "Gringo": {
                    settings.grounding = GroundingAlgo.GRINGO;
                }
            }
        }
        if (cmd.hasOption("groundingMode")) {
            String _groundingMode;
            switch (_groundingMode = cmd.getOptionValue("groundingMode", "normal")) {
                case "normal": {
                    settings.groundingMode = GroundingMode.INDEPENDENT;
                    break;
                }
                case "sequential": {
                    settings.groundingMode = GroundingMode.SEQUENTIAL;
                    break;
                }
                case "global": {
                    settings.groundingMode = GroundingMode.GLOBAL;
                }
            }
        }
        if (cmd.hasOption("distribution")) {
            String _distr = cmd.getOptionValue("distribution");
            switch (_distr.toLowerCase()) {
                case "uniform": {
                    settings.initDistribution = InitDistribution.UNIFORM;
                    break;
                }
                case "constant": {
                    settings.initDistribution = InitDistribution.CONSTANT;
                    break;
                }
                case "normal": {
                    settings.initDistribution = InitDistribution.NORMAL;
                    break;
                }
                case "longtail": {
                    settings.initDistribution = InitDistribution.LONGTAIL;
                    break;
                }
                default: {
                    LOG.severe("unrecognized distribution: " + _distr);
                }
            }
        }
        if (cmd.hasOption("initialization")) {
            String _weightInit = cmd.getOptionValue("initialization");
            switch (_weightInit.toLowerCase()) {
                case "simple": {
                    settings.initializer = InitSet.SIMPLE;
                    break;
                }
                case "glorot": {
                    settings.initializer = InitSet.GLOROT;
                    break;
                }
                case "he": {
                    settings.initializer = InitSet.HE;
                    break;
                }
                default: {
                    LOG.severe("unrecognized initialization: " + _weightInit);
                }
            }
        }
        if (cmd.hasOption("optimizer")) {
            String _optimizer = cmd.getOptionValue("optimizer", String.valueOf((Object)this.getOptimizer()));
            switch (_optimizer.toLowerCase()) {
                case "sgd": {
                    settings.setOptimizer(OptimizerSet.SGD);
                    break;
                }
                case "adam": {
                    settings.setOptimizer(OptimizerSet.ADAM);
                    break;
                }
                default: {
                    LOG.severe("unrecognized optimizer: " + _optimizer);
                }
            }
        }
        if (cmd.hasOption("learningRate")) {
            String _learningRate = cmd.getOptionValue("learningRate", String.valueOf(this.initLearningRate));
            settings.initLearningRate = Double.parseDouble(_learningRate);
        }
        if (cmd.hasOption("learnRateDecay")) {
            _decay = cmd.getOptionValue("learnRateDecay");
            settings.learnRateDecay = Double.parseDouble(_decay);
            settings.islearnRateDecay = settings.learnRateDecay > 0.0;
        }
        if (cmd.hasOption("decaySteps")) {
            _decay = cmd.getOptionValue("decaySteps");
            settings.decaySteps = Integer.parseInt(_decay);
        }
        if (cmd.hasOption("trainingSteps")) {
            String _trainingSteps = cmd.getOptionValue("trainingSteps", String.valueOf(this.maxCumEpochCount));
            settings.maxCumEpochCount = Integer.parseInt(_trainingSteps);
        }
        if (cmd.hasOption("recalculationEpocha")) {
            _limit = cmd.getOptionValue("recalculationEpocha");
            settings.resultsRecalculationEpochae = Integer.parseInt(_limit);
        }
        if (cmd.hasOption("evaluationMode")) {
            String _evaluationMode;
            switch (_evaluationMode = cmd.getOptionValue("evaluationMode", "classification")) {
                case "classification": {
                    settings.trainOnlineResultsType = ResultsType.CLASSIFICATION;
                    settings.trainRecalculationResultsType = ResultsType.DETAILEDCLASSIFICATION;
                    settings.validationResultsType = ResultsType.DETAILEDCLASSIFICATION;
                    settings.testResultsType = ResultsType.DETAILEDCLASSIFICATION;
                    break;
                }
                case "regression": {
                    settings.trainOnlineResultsType = ResultsType.REGRESSION;
                    settings.trainRecalculationResultsType = ResultsType.REGRESSION;
                    settings.validationResultsType = ResultsType.REGRESSION;
                    settings.testResultsType = ResultsType.REGRESSION;
                    break;
                }
                case "kbc": {
                    settings.trainOnlineResultsType = ResultsType.CLASSIFICATION;
                    settings.trainRecalculationResultsType = ResultsType.KBC;
                    settings.validationResultsType = ResultsType.KBC;
                    settings.testResultsType = ResultsType.KBC;
                    settings.groundingMode = GroundingMode.GLOBAL;
                }
            }
        }
        if (cmd.hasOption("errorFunction")) {
            String _errorFunction = cmd.getOptionValue("errorFunction", "MSE");
            switch (_errorFunction.toLowerCase()) {
                case "mse": {
                    settings.errorFunction = ErrorFcn.SQUARED_DIFF;
                    settings.errorAggregationFcn = CombinationFcn.AVG;
                    break;
                }
                case "xent": {
                    settings.errorFunction = ErrorFcn.CROSSENTROPY;
                    settings.errorAggregationFcn = CombinationFcn.AVG;
                }
            }
        }
        if (cmd.hasOption("atomCombination")) {
            _fnc = cmd.getOptionValue("atomCombination");
            settings.atomNeuronCombination = Settings.parseCombination(_fnc);
        }
        if (cmd.hasOption("atomTransformation")) {
            _fnc = cmd.getOptionValue("atomTransformation");
            settings.atomNeuronTransformation = Settings.parseTransformation(_fnc);
        }
        if (cmd.hasOption("ruleCombination")) {
            _fnc = cmd.getOptionValue("ruleCombination");
            settings.ruleNeuronCombination = Settings.parseCombination(_fnc);
        }
        if (cmd.hasOption("ruleTransformation")) {
            _fnc = cmd.getOptionValue("ruleTransformation");
            settings.ruleNeuronTransformation = Settings.parseTransformation(_fnc);
        }
        if (cmd.hasOption("aggFunction")) {
            _fnc = cmd.getOptionValue("aggFunction");
            settings.aggNeuronAggregation = Settings.parseCombination(_fnc);
        }
        if (cmd.hasOption("sourcesDir")) {
            settings.sourcePathProvided = true;
        }
        if (cmd.hasOption("mode")) {
            String _mode = cmd.getOptionValue("mode", String.valueOf((Object)this.mainMode));
            switch (_mode.toLowerCase()) {
                case "complete": {
                    settings.mainMode = MainMode.COMPLETE;
                    break;
                }
                case "neuralization": {
                    settings.mainMode = MainMode.NEURALIZATION;
                    break;
                }
                case "debug": {
                    settings.mainMode = MainMode.DEBUGGING;
                }
            }
        }
        if (cmd.hasOption("debug") || settings.debugAll) {
            String _debug = cmd.getOptionValue("debug", "all");
            settings.drawing = true;
            settings.mainMode = MainMode.DEBUGGING;
            switch (_debug) {
                case "all": {
                    settings.maxCumEpochCount = 2;
                    settings.resultsRecalculationEpochae = 2;
                    settings.debugAll = true;
                    settings.intermediateDebug = true;
                    settings.debugPipeline = true;
                    settings.debugTemplate = true;
                    settings.debugGrounding = true;
                    settings.debugNeuralization = true;
                    settings.debugSampleTraining = true;
                    settings.debugTemplateTraining = true;
                }
                case "template": {
                    settings.debugTemplate = true;
                    break;
                }
                case "grounding": {
                    settings.debugGrounding = true;
                    break;
                }
                case "neuralization": {
                    settings.debugNeuralization = true;
                    break;
                }
                case "samples": {
                    settings.debugSampleTraining = true;
                    break;
                }
                case "model": {
                    settings.debugTemplateTraining = true;
                }
            }
        }
        if (cmd.hasOption("limitExamples")) {
            _limit = cmd.getOptionValue("limitExamples");
            settings.appLimitSamples = Integer.parseInt(_limit);
        }
        if (cmd.hasOption("isoCompression")) {
            String _isoCompression = cmd.getOptionValue("isoCompression", String.valueOf(this.isoDecimals));
            settings.isoDecimals = Integer.parseInt(_isoCompression);
            if (settings.isoDecimals > 0) {
                settings.neuralNetsPostProcessing = true;
                settings.isoValueCompression = true;
            } else {
                settings.isoValueCompression = false;
            }
        }
        if (cmd.hasOption("isoInitializations")) {
            String _isoInits = cmd.getOptionValue("isoInitializations");
            settings.isoValueInits = Integer.parseInt(_isoInits);
        }
        if (cmd.hasOption("losslessCompression")) {
            String _losslessCompression = cmd.getOptionValue("losslessCompression");
            boolean bl = settings.structuralIsoCompression = Integer.parseInt(_losslessCompression) > 0;
        }
        if (cmd.hasOption("chainPruning")) {
            String _pruning = cmd.getOptionValue("chainPruning", String.valueOf(this.chainPruning));
            int prune = Integer.parseInt(_pruning);
            if (prune > 0) {
                settings.neuralNetsPostProcessing = true;
                settings.chainPruning = true;
            } else {
                settings.chainPruning = false;
            }
        }
        return settings;
    }

    public Boolean validate(StringBuilder message) {
        boolean valid = true;
        if (this.groundingMode == GroundingMode.SEQUENTIAL) {
            if (this.parallelGrounding) {
                valid = false;
            }
            message.append("Not possible");
        }
        if (!this.oneQueryPerExample && this.explicitSupervisedGroundTemplatePruning) {
            valid = false;
        }
        if (this.stratification && this.trainRecalculationResultsType == ResultsType.REGRESSION) {
            message.append("stratification not possible with regression");
            valid = false;
        }
        if (this.isoValueCompression && (this.atomNeuronTransformation == TransformationFcn.RELU || this.ruleNeuronTransformation == TransformationFcn.RELU)) {
            message.append("lossless network compression does not work together with ReLu activations functions.\n Either turn off the isovaluecompression or change activation function(s).");
            valid = false;
        }
        if (this.isoValueCompression && (this.aggNeuronAggregation == CombinationFcn.MAX || this.atomNeuronCombination == CombinationFcn.MAX || this.ruleNeuronCombination == CombinationFcn.MAX)) {
            message.append("lossless network compression does not work well with MAX aggregation function.\n Either turn off the isovaluecompression or change activation function(s).");
            valid = false;
        }
        return valid;
    }

    public void infer() {
        this.random = new Random(seed);
        if (this.reduceTemplate) {
            this.graphTemplate = true;
        }
        boolean bl = this.parentCounting = this.iterationMode != IterationMode.TOPOLOGIC;
        if (this.dropoutRate == 0.0 && !this.parentCounting) {
            this.neuralState = NeuralState.STANDARD;
        } else if (this.dropoutRate == 0.0 && this.parentCounting) {
            this.neuralState = NeuralState.PARENTS;
        } else if (this.dropoutRate > 0.0 && this.parentCounting) {
            this.neuralState = NeuralState.PAR_DROPOUT;
        }
        if (this.groundingMode == GroundingMode.SEQUENTIAL) {
            this.forceFullNetworks = true;
            this.possibleNeuronSharing = true;
            this.neuralNetsSupervisedPruning = false;
        }
        if (this.groundingMode == GroundingMode.GLOBAL) {
            this.possibleNeuronSharing = true;
            this.neuralNetsSupervisedPruning = false;
        }
        this.resultFile = this.outDir + "/results";
        this.settingsExportFile = this.outDir + "/settings";
        this.sourcesExportFile = this.outDir + "/sources";
        this.console = this.outDir + "/consoleOutput";
        this.exportDir = this.outDir + "/export";
        this.neuralNetsPostProcessing = this.chainPruning || this.isoValueCompression || this.neuralNetsSupervisedPruning || this.copyOutInputOvermapping || this.isoGradientCompression || this.mergeIdenticalWeightedInputs || this.removeIdenticalUnweightedInputs || this.cycleBreaking || this.collapseWeights || this.expandEmbeddings;
        if (this.validationResultsType == ResultsType.DETAILEDCLASSIFICATION || this.validationResultsType == ResultsType.KBC) {
            this.calculateBestThreshold = true;
        }
        if (this.debugAll || this.debugNeuralization || this.debugTemplateTraining || this.debugSampleTraining) {
            this.inferOutputFcns = false;
        }
        if (this.inferOutputFcns) {
            this.errorFunction = this.trainOnlineResultsType == ResultsType.REGRESSION ? ErrorFcn.SQUARED_DIFF : (this.squishLastLayer ? ErrorFcn.SOFTENTROPY : ErrorFcn.CROSSENTROPY);
        }
        if (this.errorFunction == ErrorFcn.SOFTENTROPY) {
            this.squishLastLayer = true;
        }
        this.finish();
    }

    private void finish() {
    }

    public Settings updateFromJson(Path inPath) {
        InstanceCreator<Settings> creator = type -> this;
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Settings.class), creator).create();
        try {
            String json = new String(Files.readAllBytes(inPath));
            Settings settings = gson.fromJson(json, Settings.class);
            return settings;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Settings loadFromJson(Path inPath) {
        Settings settings = new Settings().updateFromJson(inPath);
        return settings;
    }

    public String export() {
        if (this.exportType == ExportFileType.JSON) {
            return this.exportToJson();
        }
        LOG.warning("Only exporting of Settings to JSON is supported");
        return this.exportToJson();
    }

    public String exportToJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeSpecialFloatingPointValues().create();
        String json = gson.toJson(this);
        return json;
    }

    static {
        inputFilesSuffix = ".txt";
        htmlLogging = false;
        supressConsoleOutput = false;
        supressLogFileOutput = true;
        loggingLevel = Level.FINER;
        customLogColors = true;
        logFile = "./out/Logging";
        seed = 0;
        decimalFormatSymbol = new DecimalFormatSymbols(Locale.US);
        decimalFormatSymbol.setInfinity("Infinity");
        superDetailedNumberFormat = new DecimalFormat("#.################", decimalFormatSymbol);
        detailedNumberFormat = new DecimalFormat("#.##########", decimalFormatSymbol);
        defaultNumberFormat = shortNumberFormat = new DecimalFormat("#.##", decimalFormatSymbol);
    }

    public class Inferred {
        public AtomicInteger maxWeightCount = new AtomicInteger(0);
    }

    public static enum DataSelection {
        ONLINETRAIN,
        TRUETRAIN,
        VALIDATION;

    }

    public static enum ModelSelection {
        ERROR,
        ACCURACY,
        DISPERSION,
        AUCroc,
        AUCpr;

    }

    public static enum IterationMode {
        TOPOLOGIC,
        DFS_RECURSIVE,
        DFS_STACK,
        BFS;

    }

    public static enum ErrorFcn {
        SQUARED_DIFF,
        ABS_DIFF,
        CROSSENTROPY,
        SOFTENTROPY;

    }

    public static enum TransformationFcn {
        SIGMOID,
        TANH,
        SIGNUM,
        LUKASIEWICZ,
        RELU,
        LEAKYRELU,
        REVERSE,
        INVERSE,
        EXP,
        LOGARITHM,
        SQRT,
        IDENTITY,
        TRANSP,
        NORM,
        SOFTMAX,
        SPARSEMAX,
        MAX,
        MIN;

    }

    public static enum CombinationFcn {
        AVG,
        MAX,
        MIN,
        SUM,
        COUNT,
        PRODUCT,
        ELPRODUCT,
        SOFTMAX,
        SPARSEMAX,
        CROSSSUM,
        CONCAT,
        COSSIM;

    }

    public static enum HitsClashes {
        AVG,
        NONE,
        RANDOM;

    }

    public static enum HitsPreservation {
        NONE,
        FIRST_STAYS,
        MIDDLE_STAYS;

    }

    public static enum HitsCorruption {
        ONE_SAME,
        ONE_DIFF,
        ALL_DIFF;

    }

    public static enum DropoutMode {
        DROPOUT,
        DROPCONNECT,
        LIFTED_DROPCONNECT;

    }

    public static enum OptimizerSet {
        SGD,
        ADAM;

    }

    public static enum InitDistribution {
        UNIFORM,
        CONSTANT,
        NORMAL,
        LONGTAIL;

    }

    public static enum InitSet {
        SIMPLE,
        GLOROT,
        HE;

    }

    public static enum DecaySet {
        ARITHMETIC,
        GEOMETRIC;

    }

    public static enum NeuronSearch {
        LINEAR,
        BST,
        HASHMAP;

    }

    public static enum ResultsType {
        REGRESSION,
        CLASSIFICATION,
        DETAILEDCLASSIFICATION,
        KBC;

    }

    public static enum NeuralState {
        STANDARD,
        PARENTS,
        DROPOUT,
        PAR_DROPOUT;

    }

    public static enum GroundingAlgo {
        BUP,
        TDOWN,
        GRINGO;

    }

    public static enum GroundingMode {
        INDEPENDENT,
        SEQUENTIAL,
        GLOBAL;

    }

    public static enum MainMode {
        COMPLETE,
        NEURALIZATION,
        DEBUGGING;

    }

    public static enum Optimize {
        MEMORY,
        SPEED,
        TRADEOFF;

    }

    public static enum Detail {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum ExportFileType {
        JSON,
        TEXT,
        JAVA;

    }

    public static enum OS {
        LINUX,
        MACOSX,
        WINDOWS;

    }
}

