/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.exporting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import cz.cvut.fel.ida.utils.exporting.Exporter;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.Duration;

public interface Exportable<I>
extends Serializable {
    default public void export(Exporter exporter) {
        exporter.export(this);
    }

    default public String exportToJson() {
        JsonSerializer<Duration> durationJsonSerializer = (duration, type, jsonSerializationContext) -> {
            JsonObject jsonDuration = new JsonObject();
            jsonDuration.addProperty("seconds", duration.getSeconds());
            jsonDuration.addProperty("nanos", duration.getNano());
            return jsonDuration;
        };
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)Duration.class), durationJsonSerializer).serializeSpecialFloatingPointValues().create();
        String json = gson.toJson(this);
        return json;
    }
}

