/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.exporting;

import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.exporting.Exporter;
import cz.cvut.fel.ida.utils.exporting.TextExporter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class JavaExporter
extends Exporter {
    private static final Logger LOG = Logger.getLogger(JavaExporter.class.getName());
    FileOutputStream file;
    ObjectOutputStream out;

    public JavaExporter(String exportDir, String id) {
        super(exportDir, id, "JAVA");
    }

    public JavaExporter() {
    }

    @Override
    public void export(Exportable iExportable) {
        TextExporter.createFile(this.exportFile);
        try {
            if (this.out == null) {
                this.file = new FileOutputStream(this.exportFile, true);
                this.out = new ObjectOutputStream(this.file);
            }
            this.out.writeObject(iExportable);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void finish() {
        try {
            this.out.close();
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public <I> List<I> importListFrom(Path path, Class<I> cls) {
        try {
            Object tmp;
            FileInputStream myFileInputStream = new FileInputStream(String.valueOf(path));
            ObjectInputStream in = new ObjectInputStream(myFileInputStream);
            ArrayList<Object> list = new ArrayList<Object>();
            while (myFileInputStream.available() > 0 && (tmp = in.readObject()) != null) {
                list.add(tmp);
            }
            return list;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public <I> I importObjectFrom(Path path, Class<I> cls) {
        try {
            FileInputStream myFileInputStream = new FileInputStream(path.toString());
            ObjectInputStream in = new ObjectInputStream(myFileInputStream);
            Object tmp = in.readObject();
            return (I)tmp;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void delimitNext() {
    }

    @Override
    public void delimitStart() {
    }

    @Override
    public void delimitEnd() {
    }
}

