/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.exporting;

import cz.cvut.fel.ida.utils.exporting.Exporter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.logging.Logger;

public abstract class TextExporter
extends Exporter {
    private static final Logger LOG = Logger.getLogger(TextExporter.class.getName());
    PrintWriter exportWriter;
    boolean repeatedExportAppend;

    public TextExporter(String exportDir, String id, String type) {
        super(exportDir, id, type);
        if (this.exportFile.exists()) {
            this.repeatedExportAppend = true;
        }
        if (!id.equals("")) {
            this.exportWriter = TextExporter.getWriter(this.exportFile.toString(), true);
        }
    }

    protected TextExporter() {
    }

    @Override
    public void finish() {
        this.exportWriter.flush();
        this.exportWriter.close();
    }

    public void exportLine(String line) {
        this.exportWriter.println(line);
        this.exportWriter.println();
        this.exportWriter.flush();
    }

    private static PrintWriter getWriter(String filename, boolean append) {
        FileWriter fw = null;
        File file = new File(filename);
        try {
            TextExporter.createFile(file);
            fw = new FileWriter(filename, append);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter out = new PrintWriter(fw);
        return out;
    }

    public static boolean createFile(File file) {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        boolean created = false;
        try {
            created = file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return created;
    }

    public static void exportString(String exportToJson, Path exportFile) {
        LOG.info("Exporting serialized object to " + String.valueOf(exportFile));
        PrintWriter settingsWriter = TextExporter.getWriter(exportFile.toString(), false);
        settingsWriter.println(exportToJson);
        settingsWriter.flush();
        settingsWriter.close();
    }
}

