/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.utils.math.Sugar;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;

public class BigIntegerVector {
    private BigInteger[] values;

    public BigIntegerVector() {
        this.values = new BigInteger[0];
    }

    public BigIntegerVector(BigInteger[] array) {
        this.values = array;
    }

    public BigInteger sum() {
        BigInteger retVal = BigInteger.ZERO;
        for (BigInteger bi : this.values) {
            retVal = retVal.add(bi);
        }
        return retVal;
    }

    public BigInteger product() {
        BigInteger retVal = BigInteger.ONE;
        for (BigInteger bi : this.values) {
            retVal = retVal.multiply(bi);
        }
        return retVal;
    }

    public static BigIntegerVector plus(BigIntegerVector a, BigIntegerVector b) {
        BigInteger[] retVal = new BigInteger[a.values.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = a.values[i].add(b.values[i]);
        }
        return new BigIntegerVector(retVal);
    }

    public static BigIntegerVector add(BigIntegerVector a, BigInteger b) {
        BigInteger[] retVal = new BigInteger[a.values.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = a.values[i].add(b);
        }
        return new BigIntegerVector(retVal);
    }

    public static BigIntegerVector subtract(BigIntegerVector a, BigInteger b) {
        BigInteger[] retVal = new BigInteger[a.values.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = a.values[i].subtract(b);
        }
        return new BigIntegerVector(retVal);
    }

    public static BigIntegerVector multiply(BigIntegerVector a, BigInteger b) {
        BigInteger[] retVal = new BigInteger[a.values.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = a.values[i].multiply(b);
        }
        return new BigIntegerVector(retVal);
    }

    public static BigIntegerVector times(BigIntegerVector a, BigIntegerVector b) {
        BigInteger[] retVal = new BigInteger[a.values.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = a.values[i].multiply(b.values[i]);
        }
        return new BigIntegerVector(retVal);
    }

    public static BigIntegerVector sum(Collection<BigIntegerVector> vectors) {
        BigIntegerVector retVal = null;
        for (BigIntegerVector vector : vectors) {
            if (retVal == null) {
                retVal = vector;
                continue;
            }
            retVal = BigIntegerVector.plus(retVal, vector);
        }
        return retVal;
    }

    public static BigIntegerVector product(Collection<BigIntegerVector> vectors) {
        BigIntegerVector retVal = null;
        for (BigIntegerVector vector : vectors) {
            if (retVal == null) {
                retVal = vector;
                continue;
            }
            retVal = BigIntegerVector.times(retVal, vector);
        }
        return retVal;
    }

    public static BigIntegerVector remove(BigIntegerVector vector, BigInteger toBeRemoved) {
        return new BigIntegerVector(BigIntegerVector.remove(vector.values, toBeRemoved));
    }

    private static BigInteger[] remove(BigInteger[] vector, BigInteger toBeRemoved) {
        BigInteger[] newVector = new BigInteger[vector.length - Sugar.countOccurences((Object)toBeRemoved, vector)];
        int index = 0;
        for (BigInteger bi : vector) {
            if (bi.equals(toBeRemoved)) continue;
            newVector[index] = bi;
            ++index;
        }
        return newVector;
    }

    public BigInteger[] values() {
        return this.values;
    }

    public String toString() {
        return Sugar.objectArrayToString(this.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object o) {
        if (o instanceof BigIntegerVector) {
            BigIntegerVector ia = (BigIntegerVector)o;
            if (Arrays.equals(ia.values, this.values)) {
                return true;
            }
        }
        return false;
    }
}

