/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Counters<T> {
    private final HashMap<T, Integer> map;
    private static final int INITIAL_CAPACITY = 16;

    public Counters() {
        this.map = new HashMap(16);
    }

    public Counters(int expectedSize) {
        this.map = new HashMap(expectedSize);
    }

    public Counters(Collection<T> elements) {
        this(Math.max(16, (int)((float)elements.size() / 0.75f)));
        for (T t : elements) {
            this.increment(t);
        }
    }

    public static <T> Counters<T> createCounters(Set<Pair<T, Integer>> pairs) {
        Counters counters = new Counters(Math.max(16, (int)((float)pairs.size() / 0.75f)));
        for (Pair<T, Integer> pair : pairs) {
            counters.add(pair.r, (Integer)pair.s);
        }
        return counters;
    }

    public void add(T key, int value) {
        this.map.put(key, this.map.getOrDefault(key, 0) + value);
    }

    public int addPre(T key, int value) {
        int newValue = this.map.getOrDefault(key, 0) + value;
        this.map.put(key, newValue);
        return newValue;
    }

    public int addPost(T key, int value) {
        int oldValue = this.map.getOrDefault(key, 0);
        this.map.put(key, oldValue + value);
        return oldValue;
    }

    public void increment(T key) {
        this.map.put(key, this.map.getOrDefault(key, 0) + 1);
    }

    public void decrement(T key) {
        this.map.put(key, this.map.getOrDefault(key, 0) - 1);
    }

    public int get(T key) {
        return this.map.getOrDefault(key, 0);
    }

    public int incrementPre(T key) {
        int newValue = this.map.getOrDefault(key, 0) + 1;
        this.map.put(key, newValue);
        return newValue;
    }

    public int incrementPost(T key) {
        int oldValue = this.map.getOrDefault(key, 0);
        this.map.put(key, oldValue + 1);
        return oldValue;
    }

    public int decrementPre(T key) {
        int newValue = this.map.getOrDefault(key, 0) - 1;
        this.map.put(key, newValue);
        return newValue;
    }

    public int decrementPost(T key) {
        int oldValue = this.map.getOrDefault(key, 0);
        this.map.put(key, oldValue - 1);
        return oldValue;
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    public Collection<Integer> counts() {
        return this.map.values();
    }

    public void addAll(Counters<T> counters) {
        for (Map.Entry<T, Integer> entry : counters.map.entrySet()) {
            this.map.put(entry.getKey(), this.map.getOrDefault(entry.getKey(), 0) + entry.getValue());
        }
    }

    public int findMinCount() {
        int min = Integer.MAX_VALUE;
        for (int value : this.map.values()) {
            if (value >= min) continue;
            min = value;
        }
        return min == Integer.MAX_VALUE ? 0 : min;
    }

    public int findMaxCount() {
        int max = Integer.MIN_VALUE;
        for (int value : this.map.values()) {
            if (value <= max) continue;
            max = value;
        }
        return max == Integer.MIN_VALUE ? 0 : max;
    }

    public T findMin() {
        if (this.map.isEmpty()) {
            return null;
        }
        T minKey = null;
        int min = Integer.MAX_VALUE;
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            int value = entry.getValue();
            if (value >= min) continue;
            min = value;
            minKey = entry.getKey();
        }
        return minKey;
    }

    public T findMax() {
        if (this.map.isEmpty()) {
            return null;
        }
        T maxKey = null;
        int max = Integer.MIN_VALUE;
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            int value = entry.getValue();
            if (value <= max) continue;
            max = value;
            maxKey = entry.getKey();
        }
        return maxKey;
    }

    public void remove(T key) {
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<T, Integer> toMap() {
        return new HashMap<T, Integer>(this.map);
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Counters) {
            return ((Counters)o).map.equals(this.map);
        }
        return false;
    }
}

