/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DoubleCounters<T> {
    private HashMap<T, Double> map = new HashMap();

    public DoubleCounters() {
    }

    public DoubleCounters(Collection<T> elements) {
        this();
        for (T t : elements) {
            this.increment(t);
        }
    }

    public static <T> DoubleCounters<T> createCounters(Set<Pair<T, Double>> pairs) {
        DoubleCounters counters = new DoubleCounters();
        for (Pair<T, Double> pair : pairs) {
            counters.add(pair.r, (Double)pair.s);
        }
        return counters;
    }

    public void add(T key, double value) {
        this.addPre(key, value);
    }

    public double addPre(T key, double value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            this.map.put(key, this.map.get(key) + value);
        }
        return this.map.get(key);
    }

    public double addPost(T key, double value) {
        double oldValue = 0.0;
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            oldValue = this.map.get(key);
            this.map.put(key, this.map.get(key) + value);
        }
        return oldValue;
    }

    public void increment(T key) {
        this.incrementPre(key);
    }

    public void decrement(T key) {
        this.decrementPre(key);
    }

    public double get(T key) {
        if (!this.map.containsKey(key)) {
            return 0.0;
        }
        return this.map.get(key);
    }

    public double incrementPre(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, 1.0);
        } else {
            this.map.put(key, this.map.get(key) + 1.0);
        }
        return this.map.get(key);
    }

    public double incrementPost(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, 1.0);
        } else {
            this.map.put(key, this.map.get(key) + 1.0);
        }
        return this.map.get(key) - 1.0;
    }

    public double decrementPre(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, -1.0);
        } else {
            this.map.put(key, this.map.get(key) - 1.0);
        }
        return this.map.get(key);
    }

    public double decrementPost(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, -1.0);
        } else {
            this.map.put(key, this.map.get(key) - 1.0);
        }
        return this.map.get(key) + 1.0;
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    public Collection<Double> counts() {
        return this.map.values();
    }

    public void addAll(DoubleCounters<T> counters) {
        for (Map.Entry<T, Double> entry : counters.map.entrySet()) {
            if (this.map.containsKey(entry.getKey())) {
                this.map.put(entry.getKey(), this.map.get(entry.getKey()) + entry.getValue());
                continue;
            }
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleCounters) {
            return ((DoubleCounters)o).map.equals(this.map);
        }
        return false;
    }

    public Map<T, Double> toMap() {
        HashMap<T, Double> copy = new HashMap<T, Double>();
        copy.putAll(this.map);
        return copy;
    }

    public int size() {
        return this.map.size();
    }

    public double findMinCount() {
        double min = Double.POSITIVE_INFINITY;
        for (Map.Entry<T, Double> entry : this.map.entrySet()) {
            min = Math.min(min, entry.getValue());
        }
        return min;
    }

    public double findMaxCount() {
        double max = Double.NEGATIVE_INFINITY;
        for (Map.Entry<T, Double> entry : this.map.entrySet()) {
            max = Math.max(max, entry.getValue());
        }
        return max;
    }

    public T findMin() {
        T retVal = null;
        double min = Double.POSITIVE_INFINITY;
        for (Map.Entry<T, Double> entry : this.map.entrySet()) {
            min = Math.min(min, entry.getValue());
            retVal = entry.getKey();
        }
        return retVal;
    }

    public T findMax() {
        T retVal = null;
        double max = Double.NEGATIVE_INFINITY;
        for (Map.Entry<T, Double> entry : this.map.entrySet()) {
            max = Math.max(max, entry.getValue());
            retVal = entry.getKey();
        }
        return retVal;
    }
}

