/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class FixedValueToIndex<T> {
    private int lastIndex = 0;
    private int max = -1;
    private final HashMap<T, Integer> valueToIndex = new HashMap();
    private final ArrayList<T> indexToValue = new ArrayList();

    public int valueToIndex(T t) {
        Integer index = this.valueToIndex.get(t);
        if (index != null) {
            return index;
        }
        int newIndex = this.lastIndex++;
        this.valueToIndex.put(t, newIndex);
        if (newIndex >= this.indexToValue.size()) {
            this.indexToValue.add(t);
        } else {
            this.indexToValue.set(newIndex, t);
        }
        if (newIndex > this.max) {
            this.max = newIndex;
        }
        return newIndex;
    }

    public T indexToValue(int index) {
        if (index < 0 || index >= this.indexToValue.size()) {
            return null;
        }
        return this.indexToValue.get(index);
    }

    public T getValue(int index) {
        if (index < 0 || index >= this.indexToValue.size()) {
            return null;
        }
        return this.indexToValue.get(index);
    }

    public int getIndex(T value) {
        Integer index = this.valueToIndex.get(value);
        return index != null ? index : -1;
    }

    public boolean containsValue(T value) {
        return this.valueToIndex.containsKey(value);
    }

    public boolean containsIndex(int index) {
        return index >= 0 && index < this.indexToValue.size() && this.indexToValue.get(index) != null;
    }

    public void put(int key, T value) {
        if (key < 0) {
            throw new IllegalArgumentException("Index must be non-negative");
        }
        this.valueToIndex.put(value, key);
        while (key >= this.indexToValue.size()) {
            this.indexToValue.add(null);
        }
        this.indexToValue.set(key, value);
        if (key >= this.lastIndex) {
            this.lastIndex = key + 1;
        }
        if (key > this.max) {
            this.max = key;
        }
    }

    public Set<Integer> valuesToIndices(Collection<T> coll) {
        HashSet<Integer> retVal = new HashSet<Integer>(coll.size());
        for (T t : coll) {
            retVal.add(this.valueToIndex(t));
        }
        return retVal;
    }

    public Set<T> indicesToValues(Collection<Integer> coll) {
        HashSet<T> retVal = new HashSet<T>(coll.size());
        for (Integer i : coll) {
            T value;
            if (i < 0 || i >= this.indexToValue.size() || (value = this.indexToValue.get(i)) == null) continue;
            retVal.add(value);
        }
        return retVal;
    }

    public int size() {
        return this.valueToIndex.size();
    }

    public Set<T> values() {
        return this.valueToIndex.keySet();
    }

    public int max() {
        return this.max;
    }

    public String toString() {
        return this.valueToIndex.toString();
    }
}

