/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.utils.generic.tuples.Tuple;
import cz.cvut.fel.ida.utils.math.Combinatorics;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.NaturalNumbersList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class IntegerSet {
    private int hashCode = -1;
    private int[] values;
    public static final EmptySet emptySet = new EmptySet();

    private IntegerSet() {
    }

    private IntegerSet(int[] values) {
        this.values = values;
    }

    public int min() {
        return this.values[0];
    }

    public int max() {
        return this.values[this.values.length - 1];
    }

    public static IntegerSet createIntegerSet(int ... values) {
        if (values.length == 0) {
            return emptySet;
        }
        Arrays.sort(values);
        return IntegerSet.createIntegerSetFromSortedArray(values);
    }

    public static IntegerSet createIntegerSetFromSortedArray(int[] values) {
        if (values.length == 0) {
            return emptySet;
        }
        int duplicates = 0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (values[i] != values[i + 1]) continue;
            ++duplicates;
        }
        if (duplicates == 0) {
            IntegerSet retVal = new IntegerSet();
            retVal.values = values;
            return retVal;
        }
        int[] newValues = new int[values.length - duplicates];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (i != values.length - 1 && values[i] == values[i + 1]) continue;
            newValues[j++] = values[i];
        }
        IntegerSet retVal = new IntegerSet();
        retVal.values = newValues;
        return retVal;
    }

    public static IntegerSet createIntegerSet(Set<Integer> set) {
        if (set.isEmpty()) {
            return emptySet;
        }
        int[] values = new int[set.size()];
        int index = 0;
        for (int integer : set) {
            values[index++] = integer;
        }
        return IntegerSet.createIntegerSet(values);
    }

    public static IntegerSet createIntegerSetFromRange(int start, int end) {
        if (start >= end) {
            return emptySet;
        }
        int[] v = new int[end - start];
        for (int i = 0; i < v.length; ++i) {
            v[i] = start + i;
        }
        IntegerSet retVal = new IntegerSet();
        retVal.values = v;
        return retVal;
    }

    public static IntegerSet createRandomIntegerSet(int start, int end, int k) {
        return IntegerSet.createRandomIntegerSet(start, end, k, new Random());
    }

    public static IntegerSet createRandomIntegerSet(int start, int end, int k, Random random) {
        Tuple<Integer> randomTuple = Combinatorics.randomCombination(new NaturalNumbersList(start, end), k, random);
        int[] randomArray = new int[randomTuple.size()];
        for (int i = 0; i < randomArray.length; ++i) {
            randomArray[i] = randomTuple.get(i);
        }
        return IntegerSet.createIntegerSet(randomArray);
    }

    public static IntegerSet intersection(IntegerSet a, IntegerSet b) {
        if (a.isEmpty() || b.isEmpty()) {
            return emptySet;
        }
        int[] aValues = a.values;
        int[] bValues = b.values;
        if (aValues[0] > bValues[bValues.length - 1] || bValues[0] > aValues[aValues.length - 1]) {
            return emptySet;
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        int aLength = aValues.length;
        int bLength = bValues.length;
        while (indexA < aLength && indexB < bLength) {
            int aVal = aValues[indexA];
            int bVal = bValues[indexB];
            if (aVal == bVal) {
                ++count;
                ++indexA;
                ++indexB;
                continue;
            }
            if (aVal < bVal) {
                ++indexA;
                continue;
            }
            ++indexB;
        }
        if (count == 0) {
            return emptySet;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        int[] newValues = new int[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength && indexB < bLength) {
            int aVal = aValues[indexA];
            int bVal = bValues[indexB];
            if (aVal == bVal) {
                newValues[index++] = aVal;
                ++indexA;
                ++indexB;
                continue;
            }
            if (aVal < bVal) {
                ++indexA;
                continue;
            }
            ++indexB;
        }
        IntegerSet result = new IntegerSet();
        result.values = newValues;
        return result;
    }

    public static IntegerSet union(IntegerSet a, IntegerSet b) {
        if (a instanceof EmptySet) {
            return b;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        if (a == b) {
            return a;
        }
        int[] aValues = a.values;
        int[] bValues = b.values;
        int aLength = aValues.length;
        int bLength = bValues.length;
        if (aValues[aLength - 1] < bValues[0]) {
            int[] values = new int[aLength + bLength];
            System.arraycopy(aValues, 0, values, 0, aLength);
            System.arraycopy(bValues, 0, values, aLength, bLength);
            IntegerSet result = new IntegerSet();
            result.values = values;
            return result;
        }
        if (bValues[bLength - 1] < aValues[0]) {
            int[] values = new int[aLength + bLength];
            System.arraycopy(bValues, 0, values, 0, bLength);
            System.arraycopy(aValues, 0, values, bLength, aLength);
            IntegerSet result = new IntegerSet();
            result.values = values;
            return result;
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                int aVal = aValues[indexA];
                int bVal = bValues[indexB];
                if (aVal == bVal) {
                    ++indexA;
                    ++indexB;
                } else if (aVal < bVal) {
                    ++indexA;
                } else {
                    ++indexB;
                }
            } else if (indexA < aLength) {
                ++indexA;
            } else {
                ++indexB;
            }
            ++count;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        int[] newValues = new int[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                int aVal = aValues[indexA];
                int bVal = bValues[indexB];
                if (aVal == bVal) {
                    newValues[index++] = aVal;
                    ++indexA;
                    ++indexB;
                    continue;
                }
                if (aVal < bVal) {
                    newValues[index++] = aVal;
                    ++indexA;
                    continue;
                }
                newValues[index++] = bVal;
                ++indexB;
                continue;
            }
            if (indexA < aLength) {
                newValues[index++] = aValues[indexA++];
                continue;
            }
            newValues[index++] = bValues[indexB++];
        }
        IntegerSet result = new IntegerSet();
        result.values = newValues;
        return result;
    }

    public static IntegerSet difference(IntegerSet a, IntegerSet b) {
        if (a == b || a.isEmpty()) {
            return emptySet;
        }
        if (b.isEmpty()) {
            return a;
        }
        int[] aValues = a.values;
        int[] bValues = b.values;
        if (aValues[aValues.length - 1] < bValues[0] || aValues[0] > bValues[bValues.length - 1]) {
            return a;
        }
        int count = 0;
        int indexB = 0;
        int bLength = bValues.length;
        for (int indexA = 0; indexA < aValues.length; ++indexA) {
            int aVal = aValues[indexA];
            while (indexB < bLength && bValues[indexB] < aVal) {
                ++indexB;
            }
            if (indexB < bLength && bValues[indexB] == aVal) continue;
            ++count;
        }
        if (count == 0) {
            return emptySet;
        }
        if (count == aValues.length) {
            return a;
        }
        int[] newValues = new int[count];
        indexB = 0;
        int index = 0;
        for (int indexA = 0; indexA < aValues.length; ++indexA) {
            int aVal = aValues[indexA];
            while (indexB < bLength && bValues[indexB] < aVal) {
                ++indexB;
            }
            if (indexB < bLength && bValues[indexB] == aVal) continue;
            newValues[index++] = aVal;
        }
        IntegerSet result = new IntegerSet();
        result.values = newValues;
        return result;
    }

    public static boolean allAreSubsets(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).isSubsetOf(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreSubsets(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(List<IntegerSet> a) {
        for (IntegerSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(IntegerSet[] a) {
        for (IntegerSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEmpty(List<IntegerSet> a) {
        for (IntegerSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEmpty(IntegerSet[] a) {
        for (IntegerSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEmpty(IntegerSet[] a, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEmpty(IntegerSet[] a, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreSubsets(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).isSubsetOf(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreSubsets(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreSubsets(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreSubsets(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEqual(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).equals(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEqual(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static IntegerSet intersection(Collection<IntegerSet> sets) {
        IntegerSet result = null;
        for (IntegerSet set : sets) {
            if (set == null) continue;
            if (result == null) {
                result = set;
                continue;
            }
            if (!(result = IntegerSet.intersection(result, set)).isEmpty()) continue;
            return emptySet;
        }
        return result == null ? emptySet : result;
    }

    public static IntegerSet intersection(IntegerSet ... sets) {
        if (sets.length == 0) {
            return emptySet;
        }
        Arrays.sort(sets, (o1, o2) -> Integer.compare(o1.size(), o2.size()));
        IntegerSet result = sets[0];
        for (int i = 1; i < sets.length; ++i) {
            if (!(result = IntegerSet.intersection(result, sets[i])).isEmpty()) continue;
            return emptySet;
        }
        return result;
    }

    public static IntegerSet[] intersection(IntegerSet[] a, IntegerSet[] b) {
        IntegerSet[] retVal = new IntegerSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = IntegerSet.intersection(a[i], b[i]);
        }
        return retVal;
    }

    public static List<IntegerSet> intersection(List<IntegerSet> a, List<IntegerSet> b) {
        ArrayList<IntegerSet> retVal = new ArrayList<IntegerSet>(a.size());
        Iterator<IntegerSet> iter1 = a.iterator();
        Iterator<IntegerSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(IntegerSet.intersection(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public static IntegerSet union(Collection<IntegerSet> sets) {
        if (sets.isEmpty()) {
            return emptySet;
        }
        if (sets.size() > 2) {
            int totalSize = 0;
            for (IntegerSet is : sets) {
                totalSize += is.size();
            }
            if (totalSize == 0) {
                return emptySet;
            }
            int[] combined = new int[totalSize];
            int offset = 0;
            for (IntegerSet is : sets) {
                System.arraycopy(is.values, 0, combined, offset, is.size());
                offset += is.size();
            }
            return IntegerSet.createIntegerSet(combined);
        }
        IntegerSet result = null;
        for (IntegerSet set : sets) {
            if (set == null) continue;
            if (result == null) {
                result = set;
                continue;
            }
            result = IntegerSet.union(result, set);
        }
        return result == null ? emptySet : result;
    }

    public static IntegerSet union(IntegerSet ... sets) {
        if (sets.length == 0) {
            return emptySet;
        }
        if (sets.length > 2) {
            int totalSize = 0;
            for (IntegerSet is : sets) {
                totalSize += is.size();
            }
            if (totalSize == 0) {
                return emptySet;
            }
            int[] combined = new int[totalSize];
            int offset = 0;
            for (IntegerSet is : sets) {
                System.arraycopy(is.values, 0, combined, offset, is.size());
                offset += is.size();
            }
            return IntegerSet.createIntegerSet(combined);
        }
        IntegerSet result = sets[0];
        for (int i = 1; i < sets.length; ++i) {
            result = IntegerSet.union(result, sets[i]);
        }
        return result;
    }

    public static IntegerSet[] union(IntegerSet[] a, IntegerSet[] b) {
        IntegerSet[] retVal = new IntegerSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = IntegerSet.union(a[i], b[i]);
        }
        return retVal;
    }

    public static List<IntegerSet> union(List<IntegerSet> a, List<IntegerSet> b) {
        ArrayList<IntegerSet> retVal = new ArrayList<IntegerSet>(a.size());
        Iterator<IntegerSet> iter1 = a.iterator();
        Iterator<IntegerSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(IntegerSet.union(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public static int countNonEmpty(List<IntegerSet> sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(List<IntegerSet> sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (!is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEmpty(IntegerSet[] sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(IntegerSet[] sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (!is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEmpty(IntegerSet[] sets, boolean[] mask) {
        int count = 0;
        for (int i = 0; i < sets.length; ++i) {
            if (!mask[i] || sets[i].isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(IntegerSet[] sets, boolean[] mask) {
        int count = 0;
        for (int i = 0; i < sets.length; ++i) {
            if (!mask[i] || !sets[i].isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int sumSizes(IntegerSet[] sets) {
        int sum = 0;
        for (IntegerSet is : sets) {
            sum += is.size();
        }
        return sum;
    }

    public static int sumSizes(IntegerSet[] sets, boolean[] mask) {
        int sum = 0;
        for (int i = 0; i < sets.length; ++i) {
            if (!mask[i]) continue;
            sum += sets[i].size();
        }
        return sum;
    }

    public boolean contains(int integer) {
        if (this.values.length < 16) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == integer) {
                    return true;
                }
                if (this.values[i] <= integer) continue;
                return false;
            }
            return false;
        }
        return Arrays.binarySearch(this.values, integer) >= 0;
    }

    public boolean containsAny(IntegerSet b) {
        if (b.isEmpty() || this.max() < b.min() || this.min() > b.max()) {
            return false;
        }
        int i2 = 0;
        int bLength = b.values.length;
        for (int i = 0; i < this.values.length; ++i) {
            while (i2 < bLength && b.values[i2] < this.values[i]) {
                ++i2;
            }
            if (i2 == bLength || this.values[i] != b.values[i2]) continue;
            return true;
        }
        return false;
    }

    public boolean isSubsetOf(IntegerSet b) {
        if (this.isEmpty()) {
            return true;
        }
        if (b.isEmpty() || b.size() < this.size()) {
            return false;
        }
        int[] aValues = this.values;
        int[] bValues = b.values;
        if (aValues[0] < bValues[0] || aValues[aValues.length - 1] > bValues[bValues.length - 1]) {
            return false;
        }
        int i2 = 0;
        int bLength = bValues.length;
        for (int i = 0; i < aValues.length; ++i) {
            while (i2 < bLength && bValues[i2] < aValues[i]) {
                ++i2;
            }
            if (i2 != bLength && bValues[i2] <= aValues[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(IntegerSet b) {
        return !this.equals(b) && this.isSubsetOf(b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntegerSet)) {
            return false;
        }
        IntegerSet other = (IntegerSet)o;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        if (this.values.length != other.values.length) {
            return false;
        }
        if (this.values[this.values.length - 1] != other.values[other.values.length - 1]) {
            return false;
        }
        if (this.hashCode != -1 && other.hashCode != -1 && this.hashCode != other.hashCode) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == other.values[i]) continue;
            return false;
        }
        return true;
    }

    private void computeHashCode() {
        int hash = 1;
        for (int i = 0; i < this.values.length; ++i) {
            hash = (hash + 1) * (1 + this.values[i] * i * i) % 0xFFFFFF;
        }
        this.hashCode = hash;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public Set<Integer> toSet() {
        LinkedHashSet<Integer> retVal = new LinkedHashSet<Integer>(this.values.length);
        for (int i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public List<Integer> toList() {
        ArrayList<Integer> retVal = new ArrayList<Integer>(this.values.length);
        for (int i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "IntegerSet" + VectorUtils.intArrayToString(this.values);
    }

    public int[] values() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    private static class EmptySet
    extends IntegerSet {
        private EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(int integer) {
            return false;
        }

        @Override
        public boolean isSubsetOf(IntegerSet b) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptySet;
        }

        @Override
        public String toString() {
            return "EmptySet[]";
        }

        @Override
        public int[] values() {
            return new int[0];
        }

        @Override
        public Set<Integer> toSet() {
            return new HashSet<Integer>(0);
        }
    }
}

