/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiMap<R, S> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private final Set<?> emptySet = new LinkedHashSet();
    private final ConcurrentHashMap<R, Set<S>> map;

    public MultiMap() {
        this(16);
    }

    public MultiMap(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity, 0.75f, 1);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<S> get(Object key) {
        Set<S> result = this.map.get(key);
        return result != null ? result : this.emptySet;
    }

    public Set<S> getAll(Set<R> keys) {
        if (keys == null || keys.isEmpty()) {
            return this.emptySet;
        }
        HashSet<S> result = new HashSet<S>();
        for (R key : keys) {
            Set<S> values = this.map.get(key);
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public void put(R key, S value) {
        this.map.computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
    }

    public void putAll(R key, Collection<S> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        this.map.computeIfAbsent(key, k -> new LinkedHashSet()).addAll(values);
    }

    public void putAll(MultiMap<R, S> multiMap) {
        if (multiMap == null || multiMap.isEmpty()) {
            return;
        }
        for (Map.Entry<R, Set<S>> entry : multiMap.map.entrySet()) {
            Set targetSet = this.map.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet());
            targetSet.addAll((Collection)entry.getValue());
        }
    }

    public void set(R key, Set<S> value) {
        this.map.put(key, value);
    }

    public void set(R key, Collection<S> value) {
        Set targetSet = this.map.computeIfAbsent(key, k -> new LinkedHashSet(value.size()));
        targetSet.clear();
        targetSet.addAll(value);
    }

    public void remove(Object key, Object value) {
        Set<S> set = this.map.get(key);
        if (set != null && set.remove(value) && set.isEmpty()) {
            this.map.remove(key);
        }
    }

    public Set<S> remove(Object key) {
        Set<S> removed = this.map.remove(key);
        return removed != null ? removed : this.emptySet;
    }

    public void removeAll(Collection<?> keys) {
        if (keys != null) {
            keys.forEach(this.map::remove);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<R> keySet() {
        return this.map.keySet();
    }

    public Collection<Set<S>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<R, Set<S>>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MultiMap) {
            return this.map.equals(((MultiMap)o).map);
        }
        return false;
    }

    public String sizesToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultiMap[");
        int index = 0;
        for (Map.Entry<R, Set<S>> entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(" ~ ").append(entry.getValue().size());
            if (index++ >= this.map.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int[] sizes() {
        int[] sizes = new int[this.map.size()];
        int i = 0;
        for (Set<S> set : this.map.values()) {
            sizes[i++] = set.size();
        }
        return sizes;
    }
}

