/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class NaturalNumbersList
implements List<Integer> {
    private int start;
    private int end;

    public NaturalNumbersList(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.start >= this.end;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i >= this.start && i < this.end;
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        if (this.isEmpty()) {
            return new Object[0];
        }
        Object[] retVal = new Object[this.end - this.start];
        int index = 0;
        for (int i = this.start; i < this.end; ++i) {
            retVal[index] = i;
            ++index;
        }
        return retVal;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int index = 0;
        for (int i = this.start; i < this.end; ++i) {
            a[index] = new Integer(i);
            ++index;
        }
        return a;
    }

    @Override
    public boolean add(Integer e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer get(int index) {
        if (index < 0 || index >= this.end - this.start) {
            throw new IndexOutOfBoundsException();
        }
        return index + this.start;
    }

    @Override
    public Integer set(int index, Integer element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(int index, Integer element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Integer remove(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indexOf(Object o) {
        Integer i;
        if (o instanceof Integer && this.contains(i = (Integer)o)) {
            return i - this.start;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return new Iter(index);
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        if (fromIndex >= this.start && toIndex <= this.end) {
            return new NaturalNumbersList(fromIndex, toIndex);
        }
        throw new IndexOutOfBoundsException();
    }

    private class Iter
    implements ListIterator<Integer> {
        private int i;

        public Iter() {
            this.i = NaturalNumbersList.this.start;
        }

        public Iter(int index) {
            if (index >= NaturalNumbersList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.i = NaturalNumbersList.this.start + index;
        }

        @Override
        public boolean hasNext() {
            return this.i < NaturalNumbersList.this.end;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            return this.i++;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > NaturalNumbersList.this.start;
        }

        @Override
        public Integer previous() {
            if (!this.hasPrevious()) {
                throw new IndexOutOfBoundsException();
            }
            return --this.i;
        }

        @Override
        public int nextIndex() {
            return this.i - NaturalNumbersList.this.start;
        }

        @Override
        public int previousIndex() {
            return this.i - NaturalNumbersList.this.start - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void set(Integer e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void add(Integer e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

