/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ValueToIndex<T> {
    private int lastIndex = 0;
    private int max = 0;
    private final HashMap<T, Integer> valueToIndex;
    private final HashMap<Integer, T> indexToValue;
    private static final int INITIAL_CAPACITY = 16;

    public ValueToIndex() {
        this(0);
    }

    public ValueToIndex(int startIndex) {
        this.lastIndex = startIndex;
        this.max = startIndex - 1;
        this.valueToIndex = new HashMap(16);
        this.indexToValue = new HashMap(16);
    }

    public int valueToIndex(T t) {
        Integer index = this.valueToIndex.get(t);
        if (index != null) {
            return index;
        }
        int newIndex = this.lastIndex++;
        this.valueToIndex.put(t, newIndex);
        this.indexToValue.put(newIndex, t);
        this.max = newIndex;
        return newIndex;
    }

    public T indexToValue(int index) {
        return this.indexToValue.get(index);
    }

    public T getValue(int index) {
        return this.indexToValue.get(index);
    }

    public int getIndex(T value) {
        Integer index = this.valueToIndex.get(value);
        return index != null ? index : -1;
    }

    public boolean containsValue(T value) {
        return this.valueToIndex.containsKey(value);
    }

    public boolean containsIndex(int index) {
        return this.indexToValue.containsKey(index);
    }

    public void put(int key, T value) {
        this.valueToIndex.put(value, key);
        this.indexToValue.put(key, value);
        if (key >= this.lastIndex) {
            this.lastIndex = key + 1;
            this.max = key;
        } else if (key > this.max) {
            this.max = key;
        }
    }

    public Set<Integer> valuesToIndices(Collection<T> coll) {
        HashSet<Integer> retVal = new HashSet<Integer>(coll.size());
        for (T t : coll) {
            retVal.add(this.valueToIndex(t));
        }
        return retVal;
    }

    public Set<T> indicesToValues(Collection<Integer> coll) {
        HashSet<T> retVal = new HashSet<T>(coll.size());
        for (Integer i : coll) {
            T value = this.indexToValue.get(i);
            if (value == null) continue;
            retVal.add(value);
        }
        return retVal;
    }

    public Map<T, Integer> valuesToIndicesMap() {
        return this.valueToIndex;
    }

    public Map<Integer, T> indicesToValuesMap() {
        return this.indexToValue;
    }

    public int size() {
        return this.valueToIndex.size();
    }

    public Set<T> values() {
        return this.valueToIndex.keySet();
    }

    public Set<Integer> indices() {
        return this.indexToValue.keySet();
    }

    public int max() {
        return this.max;
    }

    public String toString() {
        return this.valueToIndex.toString();
    }
}

