/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.setup.Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class VectorSet {
    private static final Random random = new Random(Settings.seed);
    private static final float LOAD_FACTOR = 0.667f;
    private int capacity;
    private int size;
    private int[][] data;
    private List<int[]>[] collisions;
    private int resizeThreshold;

    public VectorSet() {
        this(32);
    }

    public VectorSet(int initialCapacity) {
        this.capacity = VectorSet.findNextPrime(initialCapacity);
        this.resizeThreshold = (int)((float)this.capacity * 0.667f);
        this.data = new int[this.capacity][];
        this.collisions = new List[this.capacity];
        this.size = 0;
    }

    public final void add(int[] vector) {
        int hash = this.hash(vector);
        int[] existing = this.data[hash];
        if (existing == null) {
            this.data[hash] = vector;
            ++this.size;
        } else {
            if (Arrays.equals(existing, vector)) {
                return;
            }
            List<int[]> collisionList = this.collisions[hash];
            if (collisionList == null) {
                this.collisions[hash] = collisionList = new ArrayList<int[]>(2);
            } else {
                for (int[] array : collisionList) {
                    if (!Arrays.equals(array, vector)) continue;
                    return;
                }
            }
            collisionList.add(vector);
            ++this.size;
        }
        if (this.size >= this.resizeThreshold) {
            this.resize();
        }
    }

    private void resize() {
        int oldCapacity = this.capacity;
        int[][] oldData = this.data;
        List<int[]>[] oldCollisions = this.collisions;
        this.capacity = VectorSet.findNextPrime(oldCapacity * 2);
        this.resizeThreshold = (int)((float)this.capacity * 0.667f);
        this.data = new int[this.capacity][];
        this.collisions = new List[this.capacity];
        this.size = 0;
        for (int[] vector : oldData) {
            if (vector == null) continue;
            this.addToNewTable(vector);
        }
        for (List<int[]> list : oldCollisions) {
            if (list == null) continue;
            for (int[] nArray : list) {
                this.addToNewTable(nArray);
            }
        }
    }

    private void addToNewTable(int[] vector) {
        int hash = this.hash(vector);
        if (this.data[hash] == null) {
            this.data[hash] = vector;
            ++this.size;
        } else {
            List<int[]> collisionList = this.collisions[hash];
            if (collisionList == null) {
                this.collisions[hash] = collisionList = new ArrayList<int[]>(2);
            }
            collisionList.add(vector);
            ++this.size;
        }
    }

    public final boolean contains(int[] vector) {
        int hash = this.hash(vector);
        int[] existing = this.data[hash];
        if (existing != null && Arrays.equals(existing, vector)) {
            return true;
        }
        List<int[]> collisionList = this.collisions[hash];
        if (collisionList != null) {
            for (int[] array : collisionList) {
                if (!Arrays.equals(array, vector)) continue;
                return true;
            }
        }
        return false;
    }

    public void printStats() {
        double num = 0.0;
        double max = 0.0;
        for (List<int[]> c : this.collisions) {
            if (c == null) continue;
            num += (double)c.size();
            max = Math.max(max, (double)c.size());
        }
        System.out.println("size: " + this.size + ", capacity: " + this.capacity + ", num collisions: " + num + ", max: " + max);
    }

    private int hash(int[] vector) {
        int hash = 0;
        for (int i = 0; i < vector.length; ++i) {
            hash = 31 * hash + vector[i];
        }
        hash ^= hash >>> 16;
        return (hash & Integer.MAX_VALUE) % this.capacity;
    }

    private static int findNextPrime(int n) {
        if (n < 2) {
            return 2;
        }
        if (n == 2) {
            return 2;
        }
        if ((n & 1) == 0) {
            ++n;
        }
        while (!VectorSet.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n < 2) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        if ((n & 1) == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }
}

