# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SelectionMark(object):
    """
    A single checkbox with selection mark.
    """

    #: A constant which can be used with the state property of a SelectionMark.
    #: This constant has a value of "UNSELECTED"
    STATE_UNSELECTED = "UNSELECTED"

    #: A constant which can be used with the state property of a SelectionMark.
    #: This constant has a value of "SELECTED"
    STATE_SELECTED = "SELECTED"

    def __init__(self, **kwargs):
        """
        Initializes a new SelectionMark object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param state:
            The value to assign to the state property of this SelectionMark.
            Allowed values for this property are: "UNSELECTED", "SELECTED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param confidence:
            The value to assign to the confidence property of this SelectionMark.
        :type confidence: float

        :param bounding_polygon:
            The value to assign to the bounding_polygon property of this SelectionMark.
        :type bounding_polygon: oci.ai_document.models.BoundingPolygon

        """
        self.swagger_types = {
            'state': 'str',
            'confidence': 'float',
            'bounding_polygon': 'BoundingPolygon'
        }
        self.attribute_map = {
            'state': 'state',
            'confidence': 'confidence',
            'bounding_polygon': 'boundingPolygon'
        }
        self._state = None
        self._confidence = None
        self._bounding_polygon = None

    @property
    def state(self):
        """
        **[Required]** Gets the state of this SelectionMark.
        String to display if checkbox is selected or not selected.

        Allowed values for this property are: "UNSELECTED", "SELECTED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this SelectionMark.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this SelectionMark.
        String to display if checkbox is selected or not selected.


        :param state: The state of this SelectionMark.
        :type: str
        """
        allowed_values = ["UNSELECTED", "SELECTED"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def confidence(self):
        """
        **[Required]** Gets the confidence of this SelectionMark.
        The confidence score, a float value between 0 and 1.


        :return: The confidence of this SelectionMark.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this SelectionMark.
        The confidence score, a float value between 0 and 1.


        :param confidence: The confidence of this SelectionMark.
        :type: float
        """
        self._confidence = confidence

    @property
    def bounding_polygon(self):
        """
        **[Required]** Gets the bounding_polygon of this SelectionMark.

        :return: The bounding_polygon of this SelectionMark.
        :rtype: oci.ai_document.models.BoundingPolygon
        """
        return self._bounding_polygon

    @bounding_polygon.setter
    def bounding_polygon(self, bounding_polygon):
        """
        Sets the bounding_polygon of this SelectionMark.

        :param bounding_polygon: The bounding_polygon of this SelectionMark.
        :type: oci.ai_document.models.BoundingPolygon
        """
        self._bounding_polygon = bounding_polygon

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
